/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.webservice.weka;

import adams.flow.webservice.AbstractWebServiceProvider;
import adams.flow.webservice.WebserviceUtils;
import adams.flow.webservice.weka.OwnedByWekaServiceWS;
import adams.flow.webservice.weka.SimpleWekaService;
import javax.xml.ws.Endpoint;
import javax.xml.ws.soap.SOAPBinding;
import nz.ac.waikato.adams.webservice.weka.WekaService;
import org.apache.cxf.jaxws.EndpointImpl;

public class WekaServiceWS
extends AbstractWebServiceProvider {
    private static final long serialVersionUID = -6865165378146103361L;
    protected transient EndpointImpl m_Endpoint;
    protected WekaService m_Implementation;

    public String globalInfo() {
        return "Provides a weka web service with the following services available:\n- training (classifiers/clusterers)\n- cross-validation (clusterers)\n- testing (classifiers)\n- making predictions (classifiers/clusterers)\n- list classifiers (classifiers/clusterers)\n- transform data\nEnable logging to see inbound/outgoing messages.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("implementation", "implementation", (Object)new SimpleWekaService());
    }

    public String getDefaultURL() {
        return "http://localhost:9090/WekaServicePort";
    }

    public void setImplementation(WekaService value) {
        this.m_Implementation = value;
        this.reset();
    }

    public WekaService getImplementation() {
        return this.m_Implementation;
    }

    public String implementationTipText() {
        return "The implementation of the webservice to use.";
    }

    protected void doStart() throws Exception {
        WekaService implementer = (WekaService)WebserviceUtils.copyImplementation((Object)this.m_Implementation);
        if (implementer instanceof OwnedByWekaServiceWS) {
            ((OwnedByWekaServiceWS)((Object)implementer)).setOwner(this);
        }
        this.m_Endpoint = (EndpointImpl)Endpoint.publish((String)this.getURL(), (Object)implementer);
        SOAPBinding binding = (SOAPBinding)this.m_Endpoint.getBinding();
        binding.setMTOMEnabled(true);
        this.configureInterceptors(this.m_Endpoint);
    }

    protected void doStop() throws Exception {
        if (this.m_Endpoint != null) {
            this.m_Endpoint.getServer().stop();
            this.m_Endpoint = null;
        }
    }
}

