/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.VariableName;
import adams.core.base.BaseRegExp;
import adams.core.base.BaseString;
import adams.core.io.AbstractTextWriter;
import adams.core.io.PlaceholderFile;
import adams.core.io.TextFileWriter;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.GlobalActorReference;
import adams.flow.sink.TextWriter;
import adams.flow.source.StringConstants;
import adams.flow.standalone.GlobalActors;
import adams.flow.transformer.SetVariable;
import adams.flow.transformer.StringReplace;
import adams.flow.transformer.WekaClassSelector;
import adams.flow.transformer.WekaClassifier;
import adams.flow.transformer.WekaCrossValidationEvaluator;
import adams.flow.transformer.WekaEvaluationSummary;
import adams.flow.transformer.WekaFileReader;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.classifiers.Classifier;
import weka.classifiers.trees.J48;

public class TextWriterTest
extends AbstractFlowTest {
    public TextWriterTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("vote.arff");
        this.m_TestHelper.copyResourceToTmp("labor.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile-vote.txt");
        this.m_TestHelper.deleteFileFromTmp("dumpfile-labor.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("labor.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile-vote.txt");
        this.m_TestHelper.deleteFileFromTmp("dumpfile-labor.txt");
        super.tearDown();
    }

    public AbstractActor getActor() {
        WekaClassifier cls = new WekaClassifier();
        cls.setName("cls");
        cls.setClassifier((Classifier)new J48());
        GlobalActors ga = new GlobalActors();
        ga.setActors(new AbstractActor[]{cls});
        StringConstants sc = new StringConstants();
        sc.setStrings(new BaseString[]{new BaseString("vote"), new BaseString("labor")});
        SetVariable sv = new SetVariable();
        sv.setVariableName(new VariableName("dataset"));
        StringReplace sr1 = new StringReplace();
        sr1.setFind(new BaseRegExp("^"));
        sr1.setReplace(this.m_TestHelper.getTmpDirectory().replace("\\", "/") + "/");
        StringReplace sr2 = new StringReplace();
        sr2.setFind(new BaseRegExp("$"));
        sr2.setReplace(".arff");
        WekaFileReader fr = new WekaFileReader();
        WekaClassSelector cs = new WekaClassSelector();
        WekaCrossValidationEvaluator cv = new WekaCrossValidationEvaluator();
        cv.setClassifier(new GlobalActorReference("cls"));
        WekaEvaluationSummary eval = new WekaEvaluationSummary();
        TextFileWriter tfw = new TextFileWriter();
        tfw.setDirectory((PlaceholderFile)new TmpFile());
        tfw.setPrefix("dumpfile-");
        tfw.setSuffix(".txt");
        TextWriter tw = new TextWriter();
        tw.setWriter((AbstractTextWriter)tfw);
        tw.getOptionManager().setVariableForProperty("contentName", "dataset");
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{ga, sc, sv, sr1, sr2, fr, cs, cv, eval, tw});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File[])new TmpFile[]{new TmpFile("dumpfile-vote.txt"), new TmpFile("dumpfile-labor.txt")});
    }

    public static Test suite() {
        return new TestSuite(TextWriterTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        TextWriterTest.runTest((Test)TextWriterTest.suite());
    }
}

