/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.instance;

import adams.core.Properties;
import adams.core.option.OptionUtils;
import adams.data.instance.Instance;
import adams.data.instance.InstancePoint;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnection;
import adams.gui.core.GUIHelper;
import adams.gui.core.Undo;
import adams.gui.event.PaintListener;
import adams.gui.scripting.AbstractScriptingEngine;
import adams.gui.scripting.ScriptingEngine;
import adams.gui.visualization.container.ContainerListManager;
import adams.gui.visualization.container.ContainerListPopupMenuSupplier;
import adams.gui.visualization.container.ContainerManager;
import adams.gui.visualization.container.ContainerTable;
import adams.gui.visualization.container.DataContainerPanel;
import adams.gui.visualization.container.DataContainerPanelWithSidePanel;
import adams.gui.visualization.core.AbstractColorProvider;
import adams.gui.visualization.core.CoordinatesPaintlet;
import adams.gui.visualization.core.DefaultColorProvider;
import adams.gui.visualization.core.PaintablePanel;
import adams.gui.visualization.core.PlotPanel;
import adams.gui.visualization.core.PopupMenuCustomizer;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.core.plot.TipTextCustomizer;
import adams.gui.visualization.instance.InstanceContainer;
import adams.gui.visualization.instance.InstanceContainerList;
import adams.gui.visualization.instance.InstanceContainerManager;
import adams.gui.visualization.instance.InstanceLinePaintlet;
import adams.gui.visualization.instance.InstancePointHitDetector;
import adams.gui.visualization.instance.InstanceZoomOverviewPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.List;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class InstancePanel
extends DataContainerPanelWithSidePanel<Instance, InstanceContainerManager>
implements PaintListener,
ContainerListPopupMenuSupplier<InstanceContainerManager, InstanceContainer>,
PopupMenuCustomizer,
TipTextCustomizer {
    private static final long serialVersionUID = 7985845939008731534L;
    protected InstanceContainerList m_InstanceContainerList;
    protected InstanceLinePaintlet m_InstancePaintlet;
    protected CoordinatesPaintlet m_CoordinatesPaintlet;
    protected Undo m_Undo;
    protected boolean m_AdjustToVisibleData;
    protected InstancePointHitDetector m_InstancePointHitDetector;
    protected int m_ToolTipMaxColumns;
    protected InstanceZoomOverviewPanel m_PanelZoomOverview;

    public InstancePanel() {
    }

    public InstancePanel(String title) {
        super(title);
    }

    protected void initialize() {
        this.m_Undo = null;
        this.m_AdjustToVisibleData = true;
        super.initialize();
    }

    protected AbstractDatabaseConnection getDefaultDatabaseConnection() {
        return DatabaseConnection.getSingleton();
    }

    protected InstanceContainerManager newContainerManager() {
        return new InstanceContainerManager((ContainerListManager<InstanceContainerManager>)this);
    }

    public InstanceLinePaintlet getContainerPaintlet() {
        return this.m_InstancePaintlet;
    }

    protected void initGUI() {
        super.initGUI();
        Properties props = this.getProperties();
        this.m_ToolTipMaxColumns = props.getInteger("Plot.ToolTip.MaxColumns", Integer.valueOf(80));
        this.setAdjustToVisibleData(props.getBoolean("Plot.AdjustToVisibleData", Boolean.valueOf(false)));
        this.m_InstanceContainerList = new InstanceContainerList();
        this.m_InstanceContainerList.setManager(this.getContainerManager());
        this.m_InstanceContainerList.setPopupMenuSupplier(this);
        this.m_InstanceContainerList.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                final ContainerTable table = InstancePanel.this.m_InstanceContainerList.getTable();
                if (table.getRowCount() > 0 && table.getSelectedRowCount() == 0) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            table.getSelectionModel().addSelectionInterval(0, 0);
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
            }
        });
        this.m_SidePanel.setLayout(new BorderLayout(0, 0));
        this.m_SidePanel.add((Component)((Object)this.m_InstanceContainerList), "Center");
        JPanel panel = new JPanel();
        panel.setMinimumSize(new Dimension(1, props.getInteger("Axis.Bottom.Width", Integer.valueOf(0))));
        panel.setPreferredSize(new Dimension(1, props.getInteger("Axis.Bottom.Width", Integer.valueOf(0))));
        this.m_SidePanel.add((Component)panel, "South");
        this.getPlot().setPopupMenuCustomizer((PopupMenuCustomizer)this);
        this.m_InstancePaintlet = new InstanceLinePaintlet();
        this.m_InstancePaintlet.setStrokeThickness(props.getDouble("Plot.StrokeThickness", Double.valueOf(1.0)).floatValue());
        this.m_InstancePaintlet.setAntiAliasingEnabled(props.getBoolean("Plot.AntiAliasing", Boolean.valueOf(true)));
        this.m_InstancePaintlet.setPanel((PaintablePanel)this);
        this.m_CoordinatesPaintlet = new CoordinatesPaintlet();
        this.m_CoordinatesPaintlet.setYInvisible(true);
        this.m_CoordinatesPaintlet.setPanel((PaintablePanel)this);
        this.m_CoordinatesPaintlet.setXColor(props.getColor("Plot.CoordinatesColor." + CoordinatesPaintlet.Coordinates.X, Color.DARK_GRAY));
        this.m_CoordinatesPaintlet.setYColor(props.getColor("Plot.CoordinatesColor." + CoordinatesPaintlet.Coordinates.Y, Color.DARK_GRAY));
        this.m_InstancePointHitDetector = new InstancePointHitDetector(this);
        this.getPlot().setTipTextCustomizer((TipTextCustomizer)this);
        try {
            ((InstanceContainerManager)this.getContainerManager()).setColorProvider((AbstractColorProvider)OptionUtils.forAnyCommandLine(AbstractColorProvider.class, (String)props.getProperty("Plot.ColorProvider", "adams.gui.visualization.core.DefaultColorProvider")));
        }
        catch (Exception e) {
            System.err.println(((Object)((Object)this)).getClass().getName() + " - Failed to set the color provider:");
            ((InstanceContainerManager)this.getContainerManager()).setColorProvider((AbstractColorProvider)new DefaultColorProvider());
        }
        this.m_PanelZoomOverview = new InstanceZoomOverviewPanel();
        this.m_PlotWrapperPanel.add((Component)((Object)this.m_PanelZoomOverview), (Object)"South");
        this.m_PanelZoomOverview.setDataContainerPanel((DataContainerPanel)this);
    }

    public ContainerManager getSequenceManager() {
        return this.m_Manager;
    }

    public void setUndo(Undo value) {
        this.m_Undo = value;
    }

    public Undo getUndo() {
        return this.m_Undo;
    }

    public boolean isUndoSupported() {
        return this.m_Undo != null;
    }

    protected boolean canPaint(Graphics g) {
        return this.getPlot() != null && this.m_Manager != null;
    }

    public void prepareUpdate() {
        double minX = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double minY = 0.0;
        double maxY = -1.7976931348623157E308;
        for (int i = 0; i < ((InstanceContainerManager)this.getContainerManager()).count(); ++i) {
            List points;
            if (this.m_AdjustToVisibleData && !((InstanceContainerManager)this.getContainerManager()).isVisible(i) || (points = ((InstanceContainer)((InstanceContainerManager)this.getContainerManager()).get(i)).getData().toList()).size() == 0) continue;
            if (InstancePoint.toDouble((Integer)((InstancePoint)((Object)points.get(0))).getX()) < minX) {
                minX = InstancePoint.toDouble((Integer)((InstancePoint)((Object)points.get(0))).getX());
            }
            if (InstancePoint.toDouble((Integer)((InstancePoint)((Object)points.get(points.size() - 1))).getX()) > maxX) {
                maxX = InstancePoint.toDouble((Integer)((InstancePoint)((Object)points.get(points.size() - 1))).getX());
            }
            for (InstancePoint point : points) {
                if (InstancePoint.toDouble((Double)point.getY()) > maxY) {
                    maxY = InstancePoint.toDouble((Double)point.getY());
                }
                if (!(InstancePoint.toDouble((Double)point.getY()) < minY)) continue;
                minY = InstancePoint.toDouble((Double)point.getY());
            }
        }
        this.getPlot().getAxis(Axis.LEFT).setMinimum(minY);
        this.getPlot().getAxis(Axis.LEFT).setMaximum(maxY);
        this.getPlot().getAxis(Axis.BOTTOM).setMinimum(minX);
        this.getPlot().getAxis(Axis.BOTTOM).setMaximum(maxX);
    }

    public void customizePopupMenu(MouseEvent e, JPopupMenu menu) {
        JMenuItem item = new JMenuItem();
        if (!this.m_InstancePaintlet.isMarkersDisabled()) {
            item.setText("Disable markers");
        } else {
            item.setText("Enable markers");
        }
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstancePanel.this.m_InstancePaintlet.setMarkersDisabled(!InstancePanel.this.m_InstancePaintlet.isMarkersDisabled());
                InstancePanel.this.repaint();
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem();
        if (this.isSidePanelVisible()) {
            item.setText("Hide side panel");
        } else {
            item.setText("Show side panel");
        }
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstancePanel.this.setSidePanelVisible(!InstancePanel.this.isSidePanelVisible());
            }
        });
        menu.add(item);
        item = new JMenuItem();
        if (this.m_AdjustToVisibleData) {
            item.setText("Adjust to loaded data");
        } else {
            item.setText("Adjust to visible data");
        }
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstancePanel.this.m_AdjustToVisibleData = !InstancePanel.this.m_AdjustToVisibleData;
                InstancePanel.this.update();
            }
        });
        menu.add(item);
    }

    public JPopupMenu getContainerListPopupMenu(ContainerTable<InstanceContainerManager, InstanceContainer> table, int row) {
        JPopupMenu result = new JPopupMenu();
        final ContainerTable<InstanceContainerManager, InstanceContainer> tableF = table;
        final int rowF = row;
        JMenuItem item = new JMenuItem("Toggle visibility");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] indices = tableF.getSelectedRows();
                if (indices.length == 0) {
                    indices = new int[]{rowF};
                }
                for (int i = 0; i < indices.length; ++i) {
                    InstanceContainer c;
                    c.setVisible(!(c = (InstanceContainer)((InstanceContainerManager)InstancePanel.this.getContainerManager()).get(indices[i])).isVisible());
                }
            }
        });
        result.add(item);
        item = new JMenuItem("Choose color...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstanceContainer cont = (InstanceContainer)((InstanceContainerManager)InstancePanel.this.getContainerManager()).get(rowF);
                Color c = JColorChooser.showDialog((Component)tableF, "Choose color for " + cont.getData().getID(), cont.getColor());
                if (c != null) {
                    cont.setColor(c);
                }
            }
        });
        result.add(item);
        result.addSeparator();
        item = new JMenuItem("Remove");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] indices = tableF.getSelectedRows();
                if (indices.length == 0) {
                    indices = new int[]{rowF + 1};
                }
                InstancePanel.this.m_InstanceContainerList.getTable().removeContainers(indices);
            }
        });
        result.add(item);
        item = new JMenuItem("Remove all");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstancePanel.this.m_InstanceContainerList.getTable().removeAllContainers();
            }
        });
        result.add(item);
        return result;
    }

    public void setZoomOverviewPanelVisible(boolean value) {
        this.m_PanelZoomOverview.setVisible(value);
    }

    public boolean isZoomOverviewPanelVisible() {
        return this.m_PanelZoomOverview.isVisible();
    }

    public void setAdjustToVisibleData(boolean value) {
        this.m_AdjustToVisibleData = value;
        this.update();
    }

    public boolean getAdjustToVisibleData() {
        return this.m_AdjustToVisibleData;
    }

    public InstanceLinePaintlet getInstancePaintlet() {
        return this.m_InstancePaintlet;
    }

    public InstanceContainerList getInstanceContainerList() {
        return this.m_InstanceContainerList;
    }

    public String processTipText(PlotPanel panel, Point mouse, String tiptext) {
        String result = tiptext;
        MouseEvent event = new MouseEvent((Component)this.getPlot().getContent(), 503, new Date().getTime(), 0, (int)mouse.getX(), (int)mouse.getY(), 0, false);
        String hit = (String)this.m_InstancePointHitDetector.detect(event);
        if (hit != null) {
            result = GUIHelper.processTipText((String)hit, (int)this.m_ToolTipMaxColumns);
        }
        return result;
    }

    public AbstractScriptingEngine getScriptingEngine() {
        return ScriptingEngine.getSingleton((AbstractDatabaseConnection)this.getDatabaseConnection());
    }

    protected void postUpdate() {
        super.postUpdate();
        if (this.m_PanelZoomOverview != null) {
            this.m_PanelZoomOverview.update();
        }
    }

    public void cleanUp() {
        if (this.m_InstancePointHitDetector != null) {
            this.m_InstancePointHitDetector.cleanUp();
            this.m_InstancePointHitDetector = null;
        }
        super.cleanUp();
    }
}

