/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.condition.test.AbstractCondition;
import adams.flow.condition.test.FileExists;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.source.ConditionalSource;
import adams.flow.source.SingleFileSupplier;
import adams.flow.transformer.WekaClassSelector;
import adams.flow.transformer.WekaClassifying;
import adams.flow.transformer.WekaFileReader;
import adams.flow.transformer.WekaInstanceDumper;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class ConditionalSourceTest
extends AbstractFlowTest {
    public ConditionalSourceTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("vote.arff");
        this.m_TestHelper.copyResourceToTmp("j48.model");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.arff");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("j48.model");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.arff");
        super.tearDown();
    }

    public AbstractActor getActor() {
        SingleFileSupplier sfs = new SingleFileSupplier();
        sfs.setFile((PlaceholderFile)new TmpFile("vote.arff"));
        WekaFileReader fr = new WekaFileReader();
        fr.setOutputType(WekaFileReader.OutputType.INCREMENTAL);
        FileExists fe = new FileExists();
        fe.setFile((PlaceholderFile)new TmpFile("vote.arff"));
        ConditionalSource conds = new ConditionalSource();
        conds.setActor((AbstractActor)sfs);
        conds.setCondition((AbstractCondition)fe);
        WekaClassSelector cs = new WekaClassSelector();
        WekaClassifying cls = new WekaClassifying();
        cls.setOutputInstance(true);
        cls.setModelFile((PlaceholderFile)new TmpFile("j48.model"));
        WekaInstanceDumper id = new WekaInstanceDumper();
        id.setOutputPrefix((PlaceholderFile)new TmpFile("dumpfile"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{conds, fr, cs, cls, id});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.arff"));
    }

    public static Test suite() {
        return new TestSuite(ConditionalSourceTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        ConditionalSourceTest.runTest((Test)ConditionalSourceTest.suite());
    }
}

