/*
 * Decompiled with CFR 0.152.
 */
package weka.core.neighboursearch;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.SelectedTag;
import weka.core.Utils;
import weka.core.neighboursearch.NewNNSearch;
import weka.core.neighboursearch.TransformNNSearch;
import weka.filters.Filter;
import weka.filters.supervised.attribute.PLSFilter;

public class PLSNNSearch
extends TransformNNSearch {
    private static final long serialVersionUID = 1915484723703917241L;
    protected PLSFilter m_plsfilter = null;
    protected int mNumComponents = 10;
    protected int m_Preprocessing = 1;

    public PLSNNSearch() {
    }

    public void setNumComponents(int nc) {
        this.mNumComponents = nc;
    }

    public int getNumComponents() {
        return this.mNumComponents;
    }

    protected Instances transformInstances(Instances in) throws Exception {
        this.m_plsfilter = this.buildFilter(this.mNumComponents);
        Instances ret = null;
        this.m_plsfilter.setInputFormat(in);
        ret = Filter.useFilter((Instances)in, (Filter)this.m_plsfilter);
        return ret;
    }

    @Override
    public Instance transformInstance(Instance in) throws Exception {
        this.m_plsfilter.input(in);
        this.m_plsfilter.batchFinished();
        return this.m_plsfilter.output();
    }

    public PLSNNSearch(Instances insts) {
        super(insts);
        try {
            Instances t_instances;
            this.m_Instances = insts;
            this.m_myInstances = t_instances = this.transformInstances(insts);
            this.m_DistanceFunction.setInstances(t_instances);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected PLSFilter buildFilter(int numcomponents) {
        PLSFilter plsfilter = new PLSFilter();
        plsfilter.setNumComponents(numcomponents);
        plsfilter.setAlgorithm(new SelectedTag(2, PLSFilter.TAGS_ALGORITHM));
        plsfilter.setPreprocessing(new SelectedTag(this.m_Preprocessing, PLSFilter.TAGS_PREPROCESSING));
        return plsfilter;
    }

    @Override
    public Instances kNearestNeighbours(Instance target, int kNN) throws Exception {
        if (this.m_Stats != null) {
            this.m_Stats.searchStart();
        }
        this.m_neighbours.clear();
        double last_distance = Double.POSITIVE_INFINITY;
        Instance t_instance = this.transformInstance(target);
        for (int i = 0; i < this.m_Instances.numInstances(); ++i) {
            double distance;
            if (target == this.m_Instances.instance(i)) continue;
            if (this.m_Stats != null) {
                this.m_Stats.incrPointCount();
            }
            if ((distance = this.m_DistanceFunction.distance(t_instance, this.m_myInstances.instance(i), last_distance, this.m_Stats)) == 0.0 && this.m_SkipIdentical || !(distance < last_distance)) continue;
            this.m_neighbours.add((Serializable)new NewNNSearch.InstanceNode(this, i, distance));
            if (this.m_neighbours.size() <= kNN) continue;
            this.m_neighbours.remove(this.m_neighbours.size() - 1);
            last_distance = ((NewNNSearch.InstanceNode)this.m_neighbours.last()).distance;
        }
        Instances neighbours = new Instances(this.m_Instances, this.m_neighbours.size());
        int index = 0;
        this.m_Distances = new double[this.m_neighbours.size()];
        for (NewNNSearch.InstanceNode in : this.m_neighbours) {
            this.m_Distances[index++] = in.distance;
            neighbours.add(this.m_Instances.instance(in.instance_index));
        }
        this.m_DistanceFunction.postProcessDistances(this.m_Distances);
        if (this.m_Stats != null) {
            this.m_Stats.searchFinish();
        }
        return neighbours;
    }

    @Override
    public void setInstances(Instances insts) throws Exception {
        Instances t_instances;
        this.m_Instances = insts;
        this.m_myInstances = t_instances = this.transformInstances(insts);
        this.m_DistanceFunction.setInstances(t_instances);
    }

    @Override
    public void update(Instance ins) throws Exception {
        if (this.m_Instances == null) {
            throw new Exception("No instances supplied yet. Cannot update withoutsupplying a set of instances first.");
        }
        this.m_DistanceFunction.update(this.transformInstance(ins));
    }

    @Override
    public void addInstanceInfo(Instance ins) {
        if (this.m_Instances != null) {
            try {
                this.update(ins);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public Enumeration listOptions() {
        Vector<Object> result = new Vector<Object>();
        result.addElement(new Option("\tThe number of PLS components to use.\n\t(default: 20)", "C", 1, "-C <components>"));
        String param = "";
        for (int i = 0; i < PLSFilter.TAGS_PREPROCESSING.length; ++i) {
            if (i > 0) {
                param = param + "|";
            }
            SelectedTag tag = new SelectedTag(PLSFilter.TAGS_PREPROCESSING[i].getID(), PLSFilter.TAGS_PREPROCESSING);
            param = param + tag.getSelectedTag().getReadable();
        }
        result.addElement(new Option("\tThe type of preprocessing that is applied to the data.\n\t(default: center)", "G", 1, "-G <" + param + ">"));
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement(en.nextElement());
        }
        return result.elements();
    }

    public void setPreprocessing(SelectedTag value) {
        if (value.getTags() == PLSFilter.TAGS_PREPROCESSING) {
            this.m_Preprocessing = value.getSelectedTag().getID();
        }
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((char)'C', (String[])options);
        if (tmpStr.length() != 0) {
            this.setNumComponents(Integer.parseInt(tmpStr));
        } else {
            this.setNumComponents(20);
        }
        tmpStr = Utils.getOption((String)"G", (String[])options);
        if (tmpStr.length() != 0) {
            this.setPreprocessing(new SelectedTag(tmpStr, PLSFilter.TAGS_PREPROCESSING));
        } else {
            this.setPreprocessing(new SelectedTag(1, PLSFilter.TAGS_PREPROCESSING));
        }
        super.setOptions(options);
    }

    public SelectedTag getPreprocessing() {
        return new SelectedTag(this.m_Preprocessing, PLSFilter.TAGS_PREPROCESSING);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-G");
        result.add("" + new SelectedTag(this.m_Preprocessing, PLSFilter.TAGS_PREPROCESSING).getSelectedTag().getReadable());
        result.add("-C");
        result.add("" + this.getNumComponents());
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        return result.toArray(new String[result.size()]);
    }
}

