/*
 * Decompiled with CFR 0.152.
 */
package adams.data.weka.evaluator;

import adams.core.ClassLister;
import adams.core.CleanUpHandler;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import weka.core.Instance;

public abstract class AbstractInstanceEvaluator
extends AbstractOptionHandler
implements CleanUpHandler {
    private static final long serialVersionUID = -7170199569631424162L;
    protected boolean m_Initialized;

    protected void reset() {
        super.reset();
        this.m_Initialized = false;
    }

    protected String setUp() {
        return null;
    }

    protected String check(Instance inst) {
        if (inst.classIsMissing()) {
            return "No class value set!";
        }
        return null;
    }

    protected abstract double doEvaluate(Instance var1);

    public double evaluate(Instance inst) {
        String msg;
        if (!this.m_Initialized) {
            msg = this.setUp();
            boolean bl = this.m_Initialized = msg == null;
            if (msg != null) {
                throw new IllegalStateException("Failed to initialize " + ((Object)((Object)this)).getClass().getName() + "!\n" + msg);
            }
        }
        if ((msg = this.check(inst)) != null) {
            throw new IllegalStateException("Instance cannot be evaluated:\n" + msg);
        }
        return this.doEvaluate(inst);
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        return OptionUtils.getCommandLine((Object)((Object)this)).compareTo(OptionUtils.getCommandLine((Object)((Object)((AbstractInstanceEvaluator)((Object)o)))));
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    public AbstractInstanceEvaluator shallowCopy() {
        return this.shallowCopy(false);
    }

    public AbstractInstanceEvaluator shallowCopy(boolean expand) {
        return (AbstractInstanceEvaluator)OptionUtils.shallowCopy((OptionHandler)this, (boolean)expand);
    }

    public static String[] getEvaluators() {
        return ClassLister.getSingleton().getClassnames(AbstractInstanceEvaluator.class);
    }

    public static AbstractInstanceEvaluator forName(String classname, String[] options) {
        AbstractInstanceEvaluator result;
        try {
            result = (AbstractInstanceEvaluator)((Object)OptionUtils.forName(AbstractInstanceEvaluator.class, (String)classname, (String[])options));
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static AbstractInstanceEvaluator forCommandLine(String cmdline) {
        return (AbstractInstanceEvaluator)AbstractOptionConsumer.fromString(ArrayConsumer.class, (String)cmdline);
    }

    public void cleanUp() {
    }

    public void destroy() {
        this.cleanUp();
        super.destroy();
    }
}

