/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractOption;
import adams.data.WekaExperimentFile;
import adams.gui.chooser.FileChooserPanel;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import adams.gui.goe.AbstractPropertyEditorSupport;
import adams.gui.goe.CustomStringRepresentationHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import weka.classifiers.Classifier;
import weka.experiment.ClassifierSplitEvaluator;
import weka.experiment.CrossValidationResultProducer;
import weka.experiment.Experiment;
import weka.experiment.ResultProducer;
import weka.experiment.SplitEvaluator;
import weka.gui.experiment.SimpleSetupPanel;

public class WekaExperimentFileEditor
extends AbstractPropertyEditorSupport
implements CustomStringRepresentationHandler {
    protected FileChooserPanel m_PanelFile;
    protected BasePanel m_PanelEditor;
    protected JButton m_ButtonEdit;
    protected JButton m_ButtonOK;
    protected JButton m_ButtonCancel;

    public static String toString(AbstractOption option, Object object) {
        return ((WekaExperimentFile)((Object)object)).getPath();
    }

    public static Object valueOf(AbstractOption option, String str) {
        return new WekaExperimentFile(str);
    }

    public String toCustomStringRepresentation(Object obj) {
        return WekaExperimentFileEditor.toString(null, obj);
    }

    public Object fromCustomStringRepresentation(String str) {
        return WekaExperimentFileEditor.valueOf(null, str);
    }

    public static Experiment newExperiment() {
        Experiment result = new Experiment();
        CrossValidationResultProducer cvrp = new CrossValidationResultProducer();
        cvrp.setNumFolds(10);
        cvrp.setSplitEvaluator((SplitEvaluator)new ClassifierSplitEvaluator());
        result.setResultProducer((ResultProducer)cvrp);
        result.setPropertyArray((Object)new Classifier[0]);
        result.setUsePropertyIterator(true);
        return result;
    }

    public String getJavaInitializationString() {
        WekaExperimentFile f = (WekaExperimentFile)((Object)this.getValue());
        if (f == null) {
            return "null";
        }
        return "new WekaExperimentFile(\"" + f.getName() + "\")";
    }

    protected JComponent createCustomEditor() {
        this.m_PanelEditor = new BasePanel();
        this.m_PanelEditor.setLayout((LayoutManager)new GridLayout(3, 1));
        this.m_PanelEditor.setBorder(BorderFactory.createEmptyBorder());
        this.m_PanelFile = new FileChooserPanel();
        WekaExperimentFile currentFile = (WekaExperimentFile)((Object)this.getValue());
        if (currentFile == null) {
            currentFile = new WekaExperimentFile(System.getProperty("user.dir"));
        }
        this.m_PanelFile.setCurrent((File)((Object)currentFile));
        this.m_PanelFile.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                File file = (File)WekaExperimentFileEditor.this.m_PanelFile.getCurrent();
                WekaExperimentFileEditor.this.m_ButtonEdit.setEnabled(!file.isDirectory());
            }
        });
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add((Component)this.m_PanelFile);
        this.m_PanelEditor.add((Component)panel);
        this.m_ButtonEdit = new JButton("Edit");
        this.m_ButtonEdit.setMnemonic('E');
        this.m_ButtonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlaceholderFile file = new PlaceholderFile((File)WekaExperimentFileEditor.this.m_PanelFile.getCurrent());
                Experiment exp = null;
                if (file.exists()) {
                    try {
                        exp = Experiment.read((String)file.getAbsolutePath());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        exp = null;
                    }
                }
                if (exp == null) {
                    exp = WekaExperimentFileEditor.newExperiment();
                }
                SimpleSetupDialog dlg = WekaExperimentFileEditor.this.m_PanelEditor.getParentDialog() != null ? new SimpleSetupDialog(WekaExperimentFileEditor.this.m_PanelEditor.getParentDialog()) : new SimpleSetupDialog(WekaExperimentFileEditor.this.m_PanelEditor.getParentFrame());
                dlg.setExperiment(exp);
                dlg.setLocationRelativeTo(dlg.getOwner());
                dlg.setVisible(true);
                try {
                    Experiment.write((String)new PlaceholderFile((File)WekaExperimentFileEditor.this.m_PanelFile.getCurrent()).getAbsolutePath(), (Experiment)dlg.getExperiment());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    GUIHelper.showErrorMessage((Component)dlg.getOwner(), (String)("Couldn't save WEKA experiment file:\n" + WekaExperimentFileEditor.this.m_PanelFile.getCurrent() + "\nReason:\n" + ex.getMessage()), (String)"Save WEKA Experiment");
                }
            }
        });
        panel = new JPanel(new FlowLayout(0));
        panel.add(this.m_ButtonEdit);
        this.m_PanelEditor.add((Component)panel);
        this.m_ButtonOK = new JButton("OK");
        this.m_ButtonOK.setMnemonic('O');
        this.m_ButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WekaExperimentFileEditor.this.setValue((Object)new WekaExperimentFile((File)WekaExperimentFileEditor.this.m_PanelFile.getCurrent()));
                WekaExperimentFileEditor.this.m_PanelEditor.closeParent();
            }
        });
        this.m_ButtonCancel = new JButton("Cancel");
        this.m_ButtonCancel.setMnemonic('C');
        this.m_ButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WekaExperimentFileEditor.this.m_PanelEditor.closeParent();
            }
        });
        panel = new JPanel(new FlowLayout(2));
        panel.add(this.m_ButtonOK);
        panel.add(this.m_ButtonCancel);
        this.m_PanelEditor.add((Component)panel);
        return this.m_PanelEditor;
    }

    protected void initForDisplay() {
        super.initForDisplay();
        WekaExperimentFile currentFile = (WekaExperimentFile)((Object)this.getValue());
        if (currentFile == null) {
            currentFile = new WekaExperimentFile(System.getProperty("user.dir"));
        }
        this.m_PanelFile.setCurrent((File)((Object)currentFile));
        this.m_ButtonEdit.setEnabled(!currentFile.isDirectory());
    }

    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getHeight()) / 2;
        WekaExperimentFile f = (WekaExperimentFile)((Object)this.getValue());
        String val = "No file";
        if (f != null) {
            val = f.toString();
        }
        gfx.drawString(val, 2, fm.getHeight() + vpad);
    }

    public static class SimpleSetupDialog
    extends JDialog {
        private static final long serialVersionUID = 7551996596456389490L;
        protected SimpleSetupPanel m_Panel;
        protected Experiment m_Experiment;
        protected JButton m_ButtonOK;
        protected JButton m_ButtonCancel;

        public SimpleSetupDialog(Frame owner) {
            super(owner, "WEKA Experiment setup", true);
            this.initialize();
            this.initGUI();
        }

        public SimpleSetupDialog(Dialog owner) {
            super(owner, "WEKA Experiment setup", true);
            this.initialize();
            this.initGUI();
        }

        protected void initialize() {
            this.m_Experiment = WekaExperimentFileEditor.newExperiment();
        }

        protected void initGUI() {
            this.setLayout(new BorderLayout());
            this.m_Panel = new SimpleSetupPanel();
            this.disableButtons((Container)this.m_Panel);
            this.add((Component)this.m_Panel, "Center");
            JPanel panel = new JPanel(new FlowLayout(2));
            this.add((Component)panel, "South");
            this.m_ButtonOK = new JButton("OK");
            this.m_ButtonOK.setMnemonic('O');
            this.m_ButtonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SimpleSetupDialog.this.m_Experiment = SimpleSetupDialog.this.m_Panel.getExperiment();
                    SimpleSetupDialog.this.setVisible(false);
                }
            });
            panel.add(this.m_ButtonOK);
            this.m_ButtonCancel = new JButton("Cancel");
            this.m_ButtonCancel.setMnemonic('C');
            this.m_ButtonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SimpleSetupDialog.this.setVisible(false);
                }
            });
            panel.add(this.m_ButtonCancel);
            this.pack();
            this.setSize(new Dimension(800, 600));
        }

        protected boolean disableButtons(Container cont) {
            boolean result = false;
            String caption = "Open...";
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                if (cont.getComponent(i) instanceof JButton) {
                    if (((JButton)cont.getComponent(i)).getText().equals(caption)) {
                        cont.setVisible(false);
                        result = true;
                    }
                } else if (cont.getComponent(i) instanceof JPanel) {
                    result = this.disableButtons((Container)cont.getComponent(i));
                }
                if (result) break;
            }
            return result;
        }

        public void setExperiment(Experiment value) {
            if (value == null) {
                value = WekaExperimentFileEditor.newExperiment();
            }
            this.m_Experiment = (Experiment)Utils.deepCopy((Object)value);
            this.m_Panel.setExperiment(value);
        }

        public Experiment getExperiment() {
            return (Experiment)Utils.deepCopy((Object)this.m_Experiment);
        }
    }
}

