/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * EvaluationStatistic.java
 * Copyright (C) 2009-2012 University of Waikato, Hamilton, New Zealand
 */
package adams.flow.core;

import adams.core.EnumWithCustomDisplay;
import adams.core.option.AbstractOption;

/**
 * The enumeration for the comparison field.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 5089 $
 */
public enum EvaluationStatistic
  implements EnumWithCustomDisplay<EvaluationStatistic> {

  NUMBER_CORRECT("Number correct (nominal)"),
  NUMBER_INCORRECT("Number incorrect (nominal)"),
  NUMBER_UNCLASSIFIED("Number unclassified (nominal)"),
  PERCENT_CORRECT("Percent correct (nominal)"),
  PERCENT_INCORRECT("Percent incorrect (nominal)"),
  PERCENT_UNCLASSIFIED("Percent unclassified (nominal)"),
  KAPPA_STATISTIC("Kappa statistic (nominal)"),
  MEAN_ABSOLUTE_ERROR("Mean absolute error"),
  ROOT_MEAN_SQUARED_ERROR("Root mean squared error"),
  RELATIVE_ABSOLUTE_ERROR("Relative absolute error"),
  ROOT_RELATIVE_SQUARED_ERROR("Root relative squared error"),
  CORRELATION_COEFFICIENT("Correlation coefficient (numeric)"),
  SF_PRIOR_ENTROPY("SF prior entropy"),
  SF_SCHEME_ENTROPY("SF scheme entropy"),
  SF_ENTROPY_GAIN("SF entropy gain"),
  SF_MEAN_PRIOR_ENTROPY("SF mean prior entropy"),
  SF_MEAN_SCHEME_ENTROPY("SF mean scheme entropy"),
  SF_MEAN_ENTROPY_GAIN("SF mean entropy gain"),
  KB_INFORMATION("KB information (nominal)"),
  KB_MEAN_INFORMATION("KB mean information (nominal)"),
  KB_RELATIVE_INFORMATION("KB relative information (nominal)"),
  TRUE_POSITIVE_RATE("True positive rate (nominal)"),
  NUM_TRUE_POSITIVES("Num true positives (nominal)"),
  FALSE_POSITIVE_RATE("False positive rate (nominal)"),
  NUM_FALSE_POSITIVES("Num false positives (nominal)"),
  TRUE_NEGATIVE_RATE("True negative rate (nominal)"),
  NUM_TRUE_NEGATIVES("Num true negatives (nominal)"),
  FALSE_NEGATIVE_RATE("False negative rate (nominal)"),
  NUM_FALSE_NEGATIVES("Num false negatives (nominal)"),
  IR_PRECISION("IR precision (nominal)"),
  IR_RECALL("IR recall (nominal)"),
  F_MEASURE("F measure (nominal)"),
  AREA_UNDER_ROC("Area under ROC (nominal)"),
  AREA_UNDER_PRC("Area under PRC (nominal)"),
  WEIGHTED_TRUE_POSITIVE_RATE("Weighted true positive rate (nominal)"),
  WEIGHTED_FALSE_POSITIVE_RATE("Weighted false positive rate (nominal)"),
  WEIGHTED_TRUE_NEGATIVE_RATE("Weighted true negative rate (nominal)"),
  WEIGHTED_FALSE_NEGATIVE_RATE("Weighted false negative rate (nominal)"),
  WEIGHTED_IR_PRECISION("Weighted IR precision (nominal)"),
  WEIGHTED_IR_RECALL("Weighted IR recall (nominal)"),
  WEIGHTED_F_MEASURE("Weighted F measure (nominal)"),
  WEIGHTED_AREA_UNDER_ROC("Weighted area under ROC (nominal)"),
  WEIGHTED_AREA_UNDER_PRC("Weighted area under PRC (nominal)");
  
  /** the display value. */
  private String m_Display;

  /** the commandline string. */
  private String m_Raw;

  /**
   * Initializes the element.
   *
   * @param display	the display value
   */
  private EvaluationStatistic(String display) {
    m_Display = display;
    m_Raw     = super.toString();
  }

  /**
   * Returns the display string.
   *
   * @return		the display string
   */
  public String toDisplay() {
    return m_Display;
  }

  /**
   * Returns the raw enum string.
   *
   * @return		the raw enum string
   */
  public String toRaw() {
    return m_Raw;
  }

  /**
   * Parses the given string and returns the associated enum.
   *
   * @param s		the string to parse
   * @return		the enum or null if not found
   */
  public EvaluationStatistic parse(String s) {
    return (EvaluationStatistic) valueOf((AbstractOption) null, s);
  }

  /**
   * Returns the display string without the "numeric" or "nominal" in
   * parentheses.
   *
   * @return		the field string
   */
  public String getField() {
    return m_Display.replaceAll(" .*", "");
  }

  /**
   * Returns the displays string.
   *
   * @return		the display string
   */
  public String toString() {
    return m_Display;
  }

  /**
   * Returns the enum as string.
   *
   * @param option	the current option
   * @param object	the enum object to convert
   * @return		the generated string
   */
  public static String toString(AbstractOption option, Object object) {
    return ((EvaluationStatistic) object).toRaw();
  }

  /**
   * Returns an enum generated from the string.
   *
   * @param option	the current option
   * @param str		the string to convert to an enum
   * @return		the generated enum or null in case of error
   */
  public static EvaluationStatistic valueOf(AbstractOption option, String str) {
    EvaluationStatistic	result;

    result = null;

    // default parsing
    try {
      result = valueOf(str);
    }
    catch (Exception e) {
      // ignored
    }

    // try display
    if (result == null) {
      for (EvaluationStatistic f: values()) {
	if (f.toDisplay().equals(str)) {
	  result = f;
	  break;
	}
      }
    }

    return result;
  }
}