/*
 * Decompiled with CFR 0.152.
 */
package adams.data.weka.rowfinder;

import adams.core.Index;
import adams.core.Utils;
import adams.core.base.BaseRegExp;
import adams.data.weka.rowfinder.AbstractRowFinder;
import java.util.ArrayList;
import weka.core.Instances;

public class ByLabel
extends AbstractRowFinder {
    private static final long serialVersionUID = 2989233908194930918L;
    protected Index m_AttributeIndex;
    protected BaseRegExp m_RegExp;

    public String globalInfo() {
        return "Returns the indices of attributes which names match the provided regular expression.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("att-index", "attributeIndex", (Object)new Index("last"));
        this.m_OptionManager.add("reg-exp", "regExp", (Object)new BaseRegExp(".*"));
    }

    public void setAttributeIndex(Index value) {
        this.m_AttributeIndex = value;
        this.reset();
    }

    public Index getAttributeIndex() {
        return this.m_AttributeIndex;
    }

    public String attributeIndexTipText() {
        return "The index of the attribute to use for matching; " + this.m_AttributeIndex.getExample();
    }

    public void setRegExp(BaseRegExp value) {
        this.m_RegExp = value;
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_RegExp;
    }

    public String regExpTipText() {
        return "The regular expression to match the attribute's labels against.";
    }

    @Override
    protected int[] doFindRows(Instances data) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        this.m_AttributeIndex.setMax(data.numAttributes());
        int index = this.m_AttributeIndex.getIntIndex();
        if (index == -1) {
            throw new IllegalStateException("Invalid index '" + this.m_AttributeIndex.getIndex() + "'?");
        }
        if (!data.attribute(index).isNominal()) {
            throw new IllegalStateException("Attribute at index '" + this.m_AttributeIndex.getIndex() + "' is not nominal!");
        }
        for (int i = 0; i < data.numInstances(); ++i) {
            if (!this.m_RegExp.isMatch(data.instance(i).stringValue(index))) continue;
            result.add(i);
        }
        return Utils.toIntArray(result);
    }
}

