/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.flow.core.AbstractActor;
import adams.flow.core.GlobalActorReference;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractWekaClassifierEvaluator;
import adams.flow.transformer.GlobalTransformer;
import weka.classifiers.Classifier;

public abstract class AbstractGlobalWekaClassifierEvaluator
extends AbstractWekaClassifierEvaluator {
    private static final long serialVersionUID = 3440872619963043115L;
    protected GlobalActorReference m_Classifier;
    protected boolean m_DiscardPredictions;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("classifier", "classifier", (Object)new GlobalActorReference("WekaClassifier"));
        this.m_OptionManager.add("no-predictions", "discardPredictions", (Object)false);
    }

    public void setClassifier(GlobalActorReference value) {
        this.m_Classifier = value;
        this.reset();
    }

    public GlobalActorReference getClassifier() {
        return this.m_Classifier;
    }

    public abstract String classifierTipText();

    public void setDiscardPredictions(boolean value) {
        this.m_DiscardPredictions = value;
        this.reset();
    }

    public boolean getDiscardPredictions() {
        return this.m_DiscardPredictions;
    }

    public String discardPredictionsTipText() {
        return "If enabled, the collection of predictions during evaluation is suppressed, wich will conserve memory.";
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("classifier");
        if (variable != null) {
            return variable;
        }
        if (this.m_Classifier != null) {
            return this.m_Classifier.toString();
        }
        return null;
    }

    public String setUp() {
        String variable;
        String result = super.setUp();
        if (result == null && (variable = this.getOptionManager().getVariableForProperty("classifier")) == null && this.m_Classifier.isEmpty()) {
            result = "No classifier specified!";
        }
        return result;
    }

    protected Classifier getClassifierInstance() {
        Classifier result = null;
        GlobalTransformer global = new GlobalTransformer();
        global.setGlobalName(this.m_Classifier);
        global.setParent(this.getParent());
        if (global.setUp() == null) {
            global.execute();
            Token token = global.output();
            if (token != null) {
                result = (Classifier)token.getPayload();
                AbstractActor actor = global.getGlobalActor();
                global.wrapUp();
                global.cleanUp();
                if (actor != null) {
                    actor.setUp();
                }
            }
        }
        return result;
    }
}

