/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Utils;
import adams.flow.container.WekaPredictionContainer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractProcessWekaInstanceWithModel;
import java.util.List;
import weka.classifiers.Classifier;
import weka.classifiers.RangeCheckClassifier;
import weka.core.Instance;

public class WekaClassifying
extends AbstractProcessWekaInstanceWithModel<Classifier> {
    private static final long serialVersionUID = -3019442578354930841L;
    protected boolean m_OutputInstance;

    public String globalInfo() {
        return "Uses a serialized model to perform predictions on the data being passed through.\nThe model can also be obtained from a global actor, if the model file is pointing to a directory.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("output-instance", "outputInstance", (Object)false);
    }

    public void setOutputInstance(boolean value) {
        this.m_OutputInstance = value;
        this.reset();
    }

    public boolean getOutputInstance() {
        return this.m_OutputInstance;
    }

    public String outputInstanceTipText() {
        return "Whether to output weka.core.Instance objects or PredictionContainer objects.";
    }

    @Override
    public Class[] generates() {
        return new Class[]{WekaPredictionContainer.class, Instance.class};
    }

    @Override
    protected Token processInstance(Instance inst) throws Exception {
        Token result;
        List<String> rangeChecks;
        String rangeCheck = null;
        if (this.m_Model instanceof RangeCheckClassifier && (rangeChecks = ((RangeCheckClassifier)this.m_Model).checkRangeForInstance(inst)).size() > 0) {
            rangeCheck = Utils.flatten(rangeChecks, (String)"\n");
        }
        WekaPredictionContainer cont = new WekaPredictionContainer(inst, ((Classifier)this.m_Model).classifyInstance(inst), ((Classifier)this.m_Model).distributionForInstance(inst), rangeCheck);
        if (this.m_OutputInstance) {
            inst = (Instance)((Instance)cont.getValue("Instance")).copy();
            inst.setClassValue(((Double)cont.getValue("Classification")).doubleValue());
            result = new Token((Object)inst);
        } else {
            result = new Token((Object)((WekaPredictionContainer)cont.getClone()));
        }
        return result;
    }
}

