/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Index;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Instances;

public class WekaInstancesInfo
extends AbstractTransformer {
    private static final long serialVersionUID = -3019442578354930841L;
    protected Vector m_Queue;
    protected InfoType m_Type;
    protected Index m_AttributeIndex;

    public String globalInfo() {
        return "Outputs statistics of a weka.core.Instances object.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)InfoType.FULL);
        this.m_OptionManager.add("attribute-index", "attributeIndex", (Object)new Index("last"));
    }

    protected void initialize() {
        super.initialize();
        this.m_AttributeIndex = new Index();
        this.m_Queue = new Vector();
    }

    public String getQuickInfo() {
        String result = null;
        String variable = this.getOptionManager().getVariableForProperty("type");
        result = variable != null ? variable : "" + (Object)((Object)this.m_Type);
        HashSet<InfoType> types = new HashSet<InfoType>(Arrays.asList(InfoType.FULL, InfoType.HEADER, InfoType.RELATION_NAME, InfoType.NUM_ATTRIBUTES, InfoType.NUM_INSTANCES, InfoType.NUM_CLASS_LABELS, InfoType.CLASS_TYPE, InfoType.CLASS_LABELS));
        if (!types.contains((Object)this.m_Type)) {
            result = result + ", index: ";
            variable = this.getOptionManager().getVariableForProperty("attributeIndex");
            result = variable != null ? result + variable : result + this.m_AttributeIndex.getIndex();
        }
        return result;
    }

    public void setType(InfoType value) {
        this.m_Type = value;
        this.reset();
    }

    public InfoType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of information to generate; NB some of the types are only available for numeric or nominal attributes.";
    }

    public void setAttributeIndex(Index value) {
        this.m_AttributeIndex = value;
        this.reset();
    }

    public Index getAttributeIndex() {
        return this.m_AttributeIndex;
    }

    public String attributeIndexTipText() {
        return "The attribute index to use for generating attribute-specific information. " + this.m_AttributeIndex.getExample();
    }

    public Class[] accepts() {
        return new Class[]{Instances.class};
    }

    public Class[] generates() {
        switch (this.m_Type) {
            case FULL: 
            case HEADER: 
            case RELATION_NAME: 
            case ATTRIBUTE_NAME: 
            case LABELS: 
            case CLASS_LABELS: 
            case ATTRIBUTE_TYPE: 
            case CLASS_TYPE: {
                return new Class[]{String.class};
            }
            case NUM_ATTRIBUTES: 
            case NUM_INSTANCES: 
            case NUM_CLASS_LABELS: 
            case NUM_LABELS: 
            case NUM_DISTINCT_VALUES: 
            case NUM_UNIQUE_VALUES: 
            case NUM_MISSING_VALUES: {
                return new Class[]{Integer.class};
            }
            case MIN: 
            case MAX: 
            case MEAN: 
            case STDEV: {
                return new Class[]{Double.class};
            }
        }
        throw new IllegalStateException("Unhandled info type: " + (Object)((Object)this.m_Type));
    }

    protected String doExecute() {
        String result = null;
        Instances inst = (Instances)this.m_InputToken.getPayload();
        this.m_AttributeIndex.setMax(inst.numAttributes());
        int index = this.m_AttributeIndex.getIntIndex();
        this.m_Queue.clear();
        switch (this.m_Type) {
            case FULL: {
                this.m_Queue.add(inst.toSummaryString());
                break;
            }
            case HEADER: {
                this.m_Queue.add(new Instances(inst, 0).toString());
                break;
            }
            case RELATION_NAME: {
                this.m_Queue.add(inst.relationName());
                break;
            }
            case ATTRIBUTE_NAME: {
                if (index == -1) break;
                this.m_Queue.add(inst.attribute(index).name());
                break;
            }
            case LABELS: {
                if (index == -1) break;
                Enumeration enm = inst.attribute(index).enumerateValues();
                while (enm.hasMoreElements()) {
                    this.m_Queue.add(enm.nextElement());
                }
                break;
            }
            case CLASS_LABELS: {
                if (inst.classIndex() <= -1) break;
                Enumeration enm = inst.classAttribute().enumerateValues();
                while (enm.hasMoreElements()) {
                    this.m_Queue.add(enm.nextElement());
                }
                break;
            }
            case NUM_ATTRIBUTES: {
                this.m_Queue.add(inst.numAttributes());
                break;
            }
            case NUM_INSTANCES: {
                this.m_Queue.add(inst.numInstances());
                break;
            }
            case NUM_CLASS_LABELS: {
                if (inst.classIndex() == -1 || !inst.classAttribute().isNominal()) break;
                this.m_Queue.add(inst.classAttribute().numValues());
                break;
            }
            case NUM_LABELS: {
                if (index == -1 || !inst.attribute(index).isNominal()) break;
                this.m_Queue.add(inst.attribute(index).numValues());
                break;
            }
            case NUM_DISTINCT_VALUES: {
                if (index == -1) break;
                this.m_Queue.add(inst.attributeStats((int)index).distinctCount);
                break;
            }
            case NUM_UNIQUE_VALUES: {
                if (index == -1) break;
                this.m_Queue.add(inst.attributeStats((int)index).uniqueCount);
                break;
            }
            case NUM_MISSING_VALUES: {
                if (index == -1) break;
                this.m_Queue.add(inst.attributeStats((int)index).missingCount);
                break;
            }
            case MIN: {
                if (index == -1 || !inst.attribute(index).isNumeric()) break;
                this.m_Queue.add(inst.attributeStats((int)index).numericStats.min);
                break;
            }
            case MAX: {
                if (index == -1 || !inst.attribute(index).isNumeric()) break;
                this.m_Queue.add(inst.attributeStats((int)index).numericStats.max);
                break;
            }
            case MEAN: {
                if (index == -1 || !inst.attribute(index).isNumeric()) break;
                this.m_Queue.add(inst.attributeStats((int)index).numericStats.mean);
                break;
            }
            case STDEV: {
                if (index == -1 || !inst.attribute(index).isNumeric()) break;
                this.m_Queue.add(inst.attributeStats((int)index).numericStats.stdDev);
                break;
            }
            case ATTRIBUTE_TYPE: {
                if (index == -1) break;
                this.m_Queue.add(Attribute.typeToString((Attribute)inst.attribute(index)));
                break;
            }
            case CLASS_TYPE: {
                if (inst.classIndex() == -1) break;
                this.m_Queue.add(Attribute.typeToString((Attribute)inst.classAttribute()));
                break;
            }
            default: {
                result = "Unhandled info type: " + (Object)((Object)this.m_Type);
            }
        }
        return result;
    }

    public Token output() {
        Token result = new Token(this.m_Queue.get(0));
        this.m_Queue.remove(0);
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_Queue.size() > 0;
    }

    public void wrapUp() {
        this.m_Queue.clear();
        super.wrapUp();
    }

    public static enum InfoType {
        FULL,
        HEADER,
        RELATION_NAME,
        NUM_ATTRIBUTES,
        NUM_INSTANCES,
        NUM_CLASS_LABELS,
        ATTRIBUTE_NAME,
        LABELS,
        CLASS_LABELS,
        NUM_LABELS,
        NUM_MISSING_VALUES,
        NUM_DISTINCT_VALUES,
        NUM_UNIQUE_VALUES,
        MIN,
        MAX,
        MEAN,
        STDEV,
        ATTRIBUTE_TYPE,
        CLASS_TYPE;

    }
}

