/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.core.io.SpreadSheet;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.SpreadSheetTable;
import adams.gui.tools.previewbrowser.AbstractSerializedObjectViewer;
import adams.gui.tools.previewbrowser.PreviewPanel;
import java.awt.Component;
import javax.swing.JComponent;
import weka.filters.unsupervised.attribute.InterquartileRange;

public class InterQuartileRangeViewer
extends AbstractSerializedObjectViewer {
    private static final long serialVersionUID = 1805163535974387818L;

    public String globalInfo() {
        return "Displays the internal values (extreme values, outliers, etc) of " + InterquartileRange.class.getName() + " objects.";
    }

    public boolean handles(Object obj) {
        return obj instanceof InterquartileRange;
    }

    protected PreviewPanel createPreview(Object obj) {
        SpreadSheet sheet = new SpreadSheet();
        InterquartileRange iqr = (InterquartileRange)obj;
        SpreadSheet.Row row = sheet.getHeaderRow();
        row.addCell("" + row.getCellCount()).setContent("Attribute Index");
        for (InterquartileRange.ValueType type : InterquartileRange.ValueType.values()) {
            row.addCell(type.toString()).setContent(type.toString());
        }
        for (int i = 0; i < iqr.getValues(InterquartileRange.ValueType.IQR).length; ++i) {
            row = sheet.addRow("" + sheet.getRowCount());
            row.addCell("" + row.getCellCount()).setContent("" + (i + 1));
            for (InterquartileRange.ValueType type : InterquartileRange.ValueType.values()) {
                row.addCell(type.toString()).setContent(Double.valueOf(iqr.getValues(type)[i]));
            }
        }
        SpreadSheetTable table = new SpreadSheetTable(sheet);
        table.setNumDecimals(6);
        PreviewPanel result = new PreviewPanel((JComponent)new BaseScrollPane((Component)table), (JComponent)table);
        return result;
    }
}

