/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.data.conversion.AnyToString;
import adams.data.conversion.Conversion;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.SingleFileSupplier;
import adams.flow.transformer.Convert;
import adams.flow.transformer.NamedSetup;
import adams.flow.transformer.WekaClassSelector;
import adams.flow.transformer.WekaFileReader;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class NamedSetupTest
extends AbstractFlowTest {
    public NamedSetupTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public AbstractActor getActor() {
        SingleFileSupplier sfs = new SingleFileSupplier();
        sfs.setFile((PlaceholderFile)new TmpFile("vote.arff"));
        WekaFileReader fr = new WekaFileReader();
        fr.setOutputType(WekaFileReader.OutputType.DATASET);
        WekaClassSelector cs = new WekaClassSelector();
        NamedSetup ext = new NamedSetup();
        ext.setSetup(new adams.core.NamedSetup("transformer_classifier_j48"));
        AnyToString a2s = new AnyToString();
        Convert con = new Convert();
        con.setConversion((Conversion)a2s);
        DumpFile df = new DumpFile();
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{sfs, fr, cs, ext, con, df});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.txt"));
    }

    public static Test suite() {
        return new TestSuite(NamedSetupTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        NamedSetupTest.runTest((Test)NamedSetupTest.suite());
    }
}

