/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Index;
import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.WekaFileWriter;
import adams.flow.source.SingleFileSupplier;
import adams.flow.transformer.WekaClassSelector;
import adams.flow.transformer.WekaFileReader;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class WekaClassSelectorTest
extends AbstractFlowTest {
    public WekaClassSelectorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("vote.xrff");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("vote.xrff");
        super.tearDown();
    }

    public AbstractActor getActor() {
        SingleFileSupplier sfs = new SingleFileSupplier();
        sfs.setFile((PlaceholderFile)new TmpFile("vote.arff"));
        WekaFileReader fr = new WekaFileReader();
        WekaClassSelector cs = new WekaClassSelector();
        cs.setClassIndex(new Index("2"));
        WekaFileWriter fw = new WekaFileWriter();
        fw.setOutputFile((PlaceholderFile)new TmpFile("vote.xrff"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{sfs, fr, cs, fw});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File[])new TmpFile[]{new TmpFile("vote.xrff")});
    }

    public static Test suite() {
        return new TestSuite(WekaClassSelectorTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        WekaClassSelectorTest.runTest((Test)WekaClassSelectorTest.suite());
    }
}

