/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.OptionUtils;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.WekaFileWriter;
import adams.flow.source.MultiFileSupplier;
import adams.flow.transformer.WekaInstancesAppend;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.ArffSaver;

public class WekaInstancesAppendTest
extends AbstractFlowTest {
    public WekaInstancesAppendTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("anneal_train.arff");
        this.m_TestHelper.copyResourceToTmp("anneal_test.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.arff");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("anneal_train.arff");
        this.m_TestHelper.deleteFileFromTmp("anneal_test.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.arff");
        super.tearDown();
    }

    public void testRegression() {
        this.performRegressionTest((File[])new TmpFile[]{new TmpFile("dumpfile.arff")});
    }

    public static Test suite() {
        return new TestSuite(WekaInstancesAppendTest.class);
    }

    public AbstractActor getActor() {
        Flow flow = new Flow();
        try {
            AbstractArgumentOption argOption = (AbstractArgumentOption)flow.getOptionManager().findByProperty("actors");
            AbstractActor[] tmp1 = new AbstractActor[3];
            MultiFileSupplier tmp2 = new MultiFileSupplier();
            tmp2.setOutputArray(true);
            argOption = (AbstractArgumentOption)tmp2.getOptionManager().findByProperty("files");
            PlaceholderFile[] tmp3 = new PlaceholderFile[]{(PlaceholderFile)argOption.valueOf("${TMP}/anneal_train.arff"), (PlaceholderFile)argOption.valueOf("${TMP}/anneal_test.arff")};
            tmp2.setFiles(tmp3);
            tmp1[0] = tmp2;
            WekaInstancesAppend tmp4 = new WekaInstancesAppend();
            tmp1[1] = tmp4;
            WekaFileWriter tmp5 = new WekaFileWriter();
            argOption = (AbstractArgumentOption)tmp5.getOptionManager().findByProperty("outputFile");
            tmp5.setOutputFile((PlaceholderFile)argOption.valueOf("${TMP}/dumpfile.arff"));
            argOption = (AbstractArgumentOption)tmp5.getOptionManager().findByProperty("customSaver");
            ArffSaver tmp8 = new ArffSaver();
            tmp8.setOptions(OptionUtils.splitOptions((String)"-decimal 6"));
            tmp5.setCustomSaver((AbstractFileSaver)tmp8);
            tmp1[2] = tmp5;
            flow.setActors(tmp1);
        }
        catch (Exception e) {
            WekaInstancesAppendTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        WekaInstancesAppendTest.runTest((Test)WekaInstancesAppendTest.suite());
    }
}

