/*
 * Decompiled with CFR 0.152.
 */
package adams.data.weka.rowfinder;

import adams.core.Range;
import adams.core.Utils;
import adams.data.weka.rowfinder.AbstractTrainableRowFinder;
import java.util.ArrayList;
import weka.core.Instance;
import weka.core.Instances;
import weka.filters.AllFilter;
import weka.filters.Filter;
import weka.filters.MultiFilter;
import weka.filters.unsupervised.attribute.InterquartileRange;

public class FilteredIQR
extends AbstractTrainableRowFinder {
    private static final long serialVersionUID = -2705356105829555109L;
    protected Filter m_PreFilter;
    protected InterquartileRange m_Filter;
    protected InterquartileRange m_ActualFilter;
    protected double m_IQR;
    protected Range m_Range;
    protected MultiFilter m_FullFilter;

    public String globalInfo() {
        return "Returns indices of rows that got identified as outliers/extreme values.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("pre-filter", "preFilter", (Object)new AllFilter());
        this.m_OptionManager.add("filter", "filter", (Object)new InterquartileRange());
        this.m_OptionManager.add("iqr", "iqr", (Object)4.25, (Number)0.0, null);
        this.m_OptionManager.add("attribute-range", "attributeRange", (Object)new Range("first-last"));
    }

    protected void initialize() {
        super.initialize();
        this.m_Range = new Range();
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_ActualFilter = null;
        this.m_FullFilter = null;
    }

    public void setPreFilter(Filter value) {
        this.m_PreFilter = value;
        this.reset();
    }

    public Filter getPreFilter() {
        return this.m_PreFilter;
    }

    public String preFilterTipText() {
        return "The filter to pre-filter the data with before subjecting it to the IQR filter.";
    }

    public void setFilter(Filter value) {
        if (value instanceof InterquartileRange) {
            this.m_Filter = (InterquartileRange)value;
            this.reset();
        } else {
            this.getSystemErr().println("Only " + InterquartileRange.class.getName() + " and derived classes are allowed, provided: " + weka.core.Utils.toCommandLine((Object)value));
        }
    }

    public Filter getFilter() {
        return this.m_Filter;
    }

    public String filterTipText() {
        return "The IQR filter to use; parameters get set internally.";
    }

    public void setIqr(double value) {
        this.m_IQR = value;
        this.reset();
    }

    public double getIqr() {
        return this.m_IQR;
    }

    public String iqrTipText() {
        return "IQR multipler for min/max values.";
    }

    public void setAttributeRange(Range value) {
        this.m_Range = value;
        this.reset();
    }

    public Range getAttributeRange() {
        return this.m_Range;
    }

    public String attributeRangeTipText() {
        return "The attribute range to work on.";
    }

    @Override
    protected boolean doTrainRowFinder(Instances data) {
        Instances labeled;
        this.m_ActualFilter = (InterquartileRange)Utils.deepCopy((Object)this.m_Filter);
        this.m_ActualFilter.setOutlierFactor(this.m_IQR);
        this.m_ActualFilter.setExtremeValuesFactor(this.m_IQR + 1.0);
        this.m_ActualFilter.setExtremeValuesAsOutliers(true);
        this.m_ActualFilter.setAttributeIndices(this.m_Range.getRange());
        this.m_FullFilter = new MultiFilter();
        this.m_FullFilter.setFilters(new Filter[]{this.m_PreFilter, this.m_ActualFilter});
        try {
            this.m_FullFilter.setInputFormat(data);
            labeled = Filter.useFilter((Instances)data, (Filter)this.m_FullFilter);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        if (labeled.numInstances() != data.numInstances()) {
            throw new IllegalStateException("Pre-filter changed number of instances in dataset? " + labeled.numInstances() + " != " + data.numInstances());
        }
        return true;
    }

    @Override
    protected int[] doFindRows(Instances data) {
        int i;
        Instances labeled;
        try {
            labeled = Filter.useFilter((Instances)data, (Filter)this.m_FullFilter);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        int index = labeled.numAttributes() - 1;
        for (i = 0; i < labeled.numInstances(); ++i) {
            Instance inst = labeled.instance(i);
            if (!inst.stringValue(index).equals("yes")) continue;
            list.add(i);
        }
        int[] result = new int[list.size()];
        for (i = 0; i < list.size(); ++i) {
            result[i] = (Integer)list.get(i);
        }
        return result;
    }
}

