/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition.bool;

import adams.core.io.PlaceholderFile;
import adams.flow.condition.bool.AbstractBooleanCondition;
import adams.flow.condition.bool.IndexedBooleanCondition;
import adams.flow.core.AbstractActor;
import adams.flow.core.GlobalActorHelper;
import adams.flow.core.GlobalActorReference;
import adams.flow.core.Token;
import weka.classifiers.Classifier;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.SerializationHelper;
import weka.core.Utils;

public class WekaClassification
extends AbstractBooleanCondition
implements IndexedBooleanCondition {
    private static final long serialVersionUID = 3278345095591806425L;
    protected PlaceholderFile m_ModelFile;
    protected GlobalActorReference m_ModelActor;
    protected Classifier m_Model;
    protected boolean m_OnTheFly;

    public String globalInfo() {
        return "Uses the index of the classification, i.e., the predicted label, as index of the switch";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("model", "modelFile", (Object)new PlaceholderFile("."));
        this.m_OptionManager.add("model-actor", "modelActor", (Object)new GlobalActorReference());
        this.m_OptionManager.add("on-the-fly", "onTheFly", (Object)false);
    }

    public void setModelFile(PlaceholderFile value) {
        this.m_ModelFile = value;
        this.reset();
    }

    public PlaceholderFile getModelFile() {
        return this.m_ModelFile;
    }

    public String modelFileTipText() {
        return "The model file to load (when not pointing to a directory).";
    }

    public void setModelActor(GlobalActorReference value) {
        this.m_ModelActor = value;
        this.reset();
    }

    public GlobalActorReference getModelActor() {
        return this.m_ModelActor;
    }

    public String modelActorTipText() {
        return "The global actor to use for obtaining the model in case serialized model file points to a directory.";
    }

    public void setOnTheFly(boolean value) {
        this.m_OnTheFly = value;
        this.reset();
    }

    public boolean getOnTheFly() {
        return this.m_OnTheFly;
    }

    public String onTheFlyTipText() {
        return "If set to true, the model file is not required to be present at set up time (eg if built on the fly), only at execution time.";
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("modelFile");
        if (variable != null) {
            return variable;
        }
        if (this.m_ModelFile != null) {
            if (this.m_ModelFile.isDirectory()) {
                return this.m_ModelActor.getValue();
            }
            return this.m_ModelFile.toString();
        }
        return null;
    }

    public Class[] accepts() {
        return new Class[]{Instance.class};
    }

    protected String setUpModel(AbstractActor owner) {
        Capabilities caps;
        String result = null;
        if (this.m_ModelFile.isDirectory()) {
            try {
                this.m_Model = (Classifier)GlobalActorHelper.getSetup(Classifier.class, (GlobalActorReference)this.m_ModelActor, (AbstractActor)owner);
            }
            catch (Exception e) {
                this.m_Model = null;
                String msg = "Failed to obtain model from global actor '" + this.m_ModelActor + "': ";
                result = msg + e.toString();
                this.getSystemErr().println(msg);
                this.getSystemErr().printStackTrace((Throwable)e);
            }
        } else {
            try {
                this.m_Model = (Classifier)SerializationHelper.read((String)this.m_ModelFile.getAbsolutePath());
            }
            catch (Exception e) {
                this.m_Model = null;
                String msg = "Failed to load model from '" + this.m_ModelFile + "': ";
                result = msg + e.toString();
                this.getSystemErr().println(msg);
                this.getSystemErr().printStackTrace((Throwable)e);
            }
        }
        if (!(this.m_Model == null || (caps = this.m_Model.getCapabilities()).handles(Capabilities.Capability.UNARY_CLASS) || caps.handles(Capabilities.Capability.BINARY_CLASS) || caps.handles(Capabilities.Capability.NOMINAL_CLASS))) {
            result = "Model can neither handle unary, binary nor nominal class attribute!";
        }
        return result;
    }

    public String setUp(AbstractActor owner) {
        String result = super.setUp(owner);
        if (result == null && !this.m_OnTheFly) {
            result = this.setUpModel(owner);
        }
        return result;
    }

    protected boolean doEvaluate(AbstractActor owner, Token token) {
        return this.getCaseIndex(owner, token) != -1;
    }

    public int getCaseIndex(AbstractActor owner, Token token) {
        String msg;
        int result = -1;
        if (this.m_OnTheFly && (msg = this.setUpModel(owner)) != null) {
            this.getSystemErr().println(msg);
            return result;
        }
        Instance inst = (Instance)token.getPayload();
        if (inst.classIndex() == -1) {
            this.getSystemErr().println("No class set!");
            return result;
        }
        if (!inst.classAttribute().isNominal()) {
            this.getSystemErr().println("Class attribute is not nominal!");
            return result;
        }
        try {
            double classification = this.m_Model.classifyInstance(inst);
            result = Utils.isMissingValue((double)classification) ? -1 : (int)classification;
        }
        catch (Exception e) {
            this.getSystemErr().printStackTrace("Failed to obtain classification: ", (Throwable)e);
        }
        return result;
    }

    public int getDefaultCaseIndex(AbstractActor owner, Token token) {
        Instance inst = (Instance)token.getPayload();
        return inst.classAttribute().numValues();
    }
}

