/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.converters.ConverterUtils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;

public class WekaInstancesMerge
extends AbstractTransformer
implements ProvenanceSupporter {
    private static final long serialVersionUID = -2923715594018710295L;
    protected boolean m_UsePrefix;
    protected boolean m_AddIndex;
    protected String m_Prefix;
    protected String m_PrefixSeparator;
    protected String m_ExcludedAttributes;
    protected boolean m_InvertMatchingSense;
    protected String m_UniqueID;
    protected int m_AttType;

    public String globalInfo() {
        return "Merges multiple datasets.\nIf no 'ID' attribute is named, then all datasets must contain the same number of rows.\nAttributes can be excluded from ending up in the final dataset via a regular expression. They can also be prefixed with name and/or index.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("use-prefix", "usePrefix", (Object)false);
        this.m_OptionManager.add("add-index", "addIndex", (Object)false);
        this.m_OptionManager.add("prefix", "prefix", (Object)"dataset");
        this.m_OptionManager.add("prefix-separator", "prefixSeparator", (Object)"-");
        this.m_OptionManager.add("exclude-atts", "excludedAttributes", (Object)"");
        this.m_OptionManager.add("invert", "invertMatchingSense", (Object)false);
        this.m_OptionManager.add("unique-id", "uniqueID", (Object)"");
    }

    public void setUsePrefix(boolean value) {
        this.m_UsePrefix = value;
        this.reset();
    }

    public boolean getUsePrefix() {
        return this.m_UsePrefix;
    }

    public String usePrefixTipText() {
        return "Whether to prefix the attribute names of each dataset with an index and an optional string.";
    }

    public void setAddIndex(boolean value) {
        this.m_AddIndex = value;
        this.reset();
    }

    public boolean getAddIndex() {
        return this.m_AddIndex;
    }

    public String addIndexTipText() {
        return "Whether to add the index of the dataset to the prefix.";
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The optional prefix string to prefix the index number with (in case prefixes are used); '@' is a placeholder for the relation name.";
    }

    public void setPrefixSeparator(String value) {
        this.m_PrefixSeparator = value;
        this.reset();
    }

    public String getPrefixSeparator() {
        return this.m_PrefixSeparator;
    }

    public String prefixSeparatorTipText() {
        return "The separator string between the generated prefix and the original attribute name.";
    }

    public void setExcludedAttributes(String value) {
        this.m_ExcludedAttributes = value;
        this.reset();
    }

    public String getExcludedAttributes() {
        return this.m_ExcludedAttributes;
    }

    public String excludedAttributesTipText() {
        return "The regular expression used on the attribute names, to determine whether an attribute should be excluded or not (matching sense can be inverted); leave empty to include all attributes.";
    }

    public void setInvertMatchingSense(boolean value) {
        this.m_InvertMatchingSense = value;
        this.reset();
    }

    public boolean getInvertMatchingSense() {
        return this.m_InvertMatchingSense;
    }

    public String invertMatchingSenseTipText() {
        return "Whether to invert the matching sense of excluding attributes, ie, the regular expression is used for including attributes.";
    }

    public void setUniqueID(String value) {
        this.m_UniqueID = value;
        this.reset();
    }

    public String getUniqueID() {
        return this.m_UniqueID;
    }

    public String uniqueIDTipText() {
        return "The name of the attribute (string/numeric) used for uniquely identifying rows among the datasets.";
    }

    public Class[] accepts() {
        return new Class[]{String[].class, File[].class};
    }

    public Class[] generates() {
        return new Class[]{Instances.class};
    }

    protected Instances excludeAttributes(Instances inst, int index) {
        Instances result;
        StringBuilder atts = new StringBuilder();
        for (int i = 0; i < inst.numAttributes(); ++i) {
            if (!inst.attribute(i).name().matches(this.m_ExcludedAttributes)) continue;
            if (atts.length() > 0) {
                atts.append(",");
            }
            atts.append(i + 1);
        }
        try {
            Remove filter = new Remove();
            filter.setAttributeIndices(atts.toString());
            filter.setInvertSelection(this.m_InvertMatchingSense);
            filter.setInputFormat(inst);
            result = Filter.useFilter((Instances)inst, (Filter)filter);
        }
        catch (Exception e) {
            result = inst;
            this.handleException("Error filtering data:", e);
        }
        return result;
    }

    protected Instances prefixAttributes(Instances inst, int index) {
        int i;
        String prefix = this.m_Prefix.equals("@") ? inst.relationName() : this.m_Prefix;
        if (this.m_AddIndex) {
            prefix = prefix + this.m_PrefixSeparator + (index + 1);
        }
        prefix = prefix + this.m_PrefixSeparator;
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        for (i = 0; i < inst.numAttributes(); ++i) {
            atts.add(inst.attribute(i).copy(prefix + inst.attribute(i).name()));
        }
        Instances result = new Instances(inst.relationName(), atts, inst.numInstances());
        result.setClassIndex(inst.classIndex());
        for (i = 0; i < inst.numInstances(); ++i) {
            result.add((Instance)inst.instance(i).copy());
        }
        return result;
    }

    protected Instances prepareData(Instances inst, int index) {
        Instances result = inst;
        if (this.m_ExcludedAttributes.length() > 0) {
            result = this.excludeAttributes(result, index);
        }
        if (this.m_UsePrefix) {
            result = this.prefixAttributes(inst, index);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void updateIDs(Instances inst, HashSet ids) {
        Attribute att = inst.attribute(this.m_UniqueID);
        if (att == null) {
            throw new IllegalStateException("Attribute '" + this.m_UniqueID + "' not found in relation '" + inst.relationName() + "'!");
        }
        if (this.m_AttType == -1) {
            if (att.type() != 0 && att.type() != 2) throw new IllegalStateException("Attribute '" + this.m_UniqueID + "' must be either NUMERIC or STRING!");
            this.m_AttType = att.type();
        } else if (this.m_AttType != att.type()) {
            throw new IllegalStateException("Attribute '" + this.m_UniqueID + "' must have same attribute type in all the datasets!");
        }
        for (int i = 0; i < inst.numInstances(); ++i) {
            if (this.m_AttType == 0) {
                ids.add(inst.instance(i).value(att));
                continue;
            }
            ids.add(inst.instance(i).stringValue(att));
        }
    }

    protected Instances merge(Instances[] orig, Instances[] inst, HashSet ids) {
        int n;
        int i;
        if (this.isDebugOn()) {
            this.debug("Creating merged header...");
        }
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        String relation = "";
        int[] indexStart = new int[inst.length];
        for (i = 0; i < inst.length; ++i) {
            indexStart[i] = atts.size();
            for (n = 0; n < inst[i].numAttributes(); ++n) {
                atts.add((Attribute)inst[i].attribute(n).copy());
            }
            if (i > 0) {
                relation = relation + "_";
            }
            relation = relation + inst[i].relationName();
        }
        Instances result = new Instances(relation, atts, ids.size());
        if (this.isDebugOn()) {
            this.debug("Filling with missing values...");
        }
        for (i = 0; i < ids.size(); ++i) {
            if (this.isStopped()) {
                return null;
            }
            if (this.isDebugOn() && (i + 1) % 1000 == 0) {
                this.debug("" + (i + 1));
            }
            result.add((Instance)new DenseInstance(result.numAttributes()));
        }
        if (this.isDebugOn()) {
            this.debug("Sorting indices...");
        }
        Vector sortedIDs = new Vector(ids);
        Collections.sort(sortedIDs);
        for (i = 0; i < inst.length; ++i) {
            if (this.isStopped()) {
                return null;
            }
            if (this.isDebugOn()) {
                this.debug("Adding file #" + (i + 1));
            }
            Attribute att = orig[i].attribute(this.m_UniqueID);
            for (n = 0; n < inst[i].numInstances(); ++n) {
                int index;
                if (this.isDebugOn() && (n + 1) % 1000 == 0) {
                    this.debug("" + (n + 1));
                }
                if ((index = this.m_AttType == 0 ? Collections.binarySearch(sortedIDs, inst[i].instance(n).value(att)) : Collections.binarySearch(sortedIDs, inst[i].instance(n).stringValue(att))) < 0) {
                    throw new IllegalStateException("Failed to determine index for row #" + (n + 1) + " of dataset #" + (i + 1) + "!");
                }
                double[] values = result.instance(index).toDoubleArray();
                block10: for (int m = 0; m < inst[i].numAttributes(); ++m) {
                    if (inst[i].instance(n).isMissing(m)) continue;
                    switch (inst[i].attribute(m).type()) {
                        case 0: 
                        case 1: 
                        case 3: {
                            values[indexStart[i] + m] = inst[i].instance(n).value(m);
                            continue block10;
                        }
                        case 2: {
                            double value;
                            values[indexStart[i] + m] = value = (double)result.attribute(indexStart[i] + m).addStringValue(inst[i].instance(n).stringValue(m));
                            continue block10;
                        }
                        case 4: {
                            double value;
                            values[indexStart[i] + m] = value = (double)result.attribute(indexStart[i] + m).addRelation(inst[i].instance(n).relationalValue(m));
                            continue block10;
                        }
                        default: {
                            throw new IllegalStateException("Unhandled attribute type: " + inst[i].attribute(m).type());
                        }
                    }
                }
                result.set(index, (Instance)new DenseInstance(1.0, values));
            }
        }
        return result;
    }

    protected String doExecute() {
        int i;
        File[] files;
        String result = null;
        if (this.m_InputToken.getPayload() instanceof String[]) {
            String[] filesStr = (String[])this.m_InputToken.getPayload();
            files = new File[filesStr.length];
            for (i = 0; i < filesStr.length; ++i) {
                files[i] = new PlaceholderFile(filesStr[i]);
            }
        } else if (this.m_InputToken.getPayload() instanceof File[]) {
            files = (File[])this.m_InputToken.getPayload();
        } else {
            throw new IllegalStateException("Unhandled input type: " + this.m_InputToken.getPayload().getClass());
        }
        try {
            Instances output = null;
            if (this.m_UniqueID.length() == 0) {
                Instances[] inst = new Instances[1];
                for (i = 0; i < files.length && !this.isStopped(); ++i) {
                    inst[0] = ConverterUtils.DataSource.read((String)files[i].getAbsolutePath());
                    inst[0] = this.prepareData(inst[0], i);
                    if (i == 0) {
                        output = inst[0];
                        continue;
                    }
                    if (this.isDebugOn()) {
                        this.debug("Merging with file #" + (i + 1) + ": " + files[i]);
                    }
                    output = Instances.mergeInstances((Instances)output, (Instances)inst[0]);
                }
            } else {
                Instances[] orig = new Instances[files.length];
                Instances[] inst = new Instances[files.length];
                this.m_AttType = -1;
                int max = 0;
                for (i = 0; i < files.length && !this.isStopped(); ++i) {
                    if (this.isDebugOn()) {
                        this.debug("Loading file #" + (i + 1) + ": " + files[i]);
                    }
                    orig[i] = ConverterUtils.DataSource.read((String)files[i].getAbsolutePath());
                    max = Math.max(max, orig[i].numInstances());
                }
                HashSet ids = new HashSet(max);
                for (i = 0; i < files.length && !this.isStopped(); ++i) {
                    if (this.isDebugOn()) {
                        this.debug("Updating IDs #" + (i + 1));
                    }
                    this.updateIDs(orig[i], ids);
                    if (this.isDebugOn()) {
                        this.debug("Preparing dataset #" + (i + 1));
                    }
                    inst[i] = this.prepareData(orig[i], i);
                }
                output = this.merge(orig, inst, ids);
            }
            if (!this.isStopped()) {
                this.m_OutputToken = new Token(output);
                this.updateProvenance((ProvenanceContainer)this.m_OutputToken);
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to merge: ", e);
        }
        return result;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            cont.addProvenance(new ProvenanceInformation(ActorType.DATAGENERATOR, this.m_InputToken.getPayload().getClass(), (AbstractActor)this, this.m_OutputToken.getPayload().getClass()));
        }
    }
}

