/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.lang.reflect.Constructor;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

public class WekaNewInstance
extends AbstractTransformer {
    private static final long serialVersionUID = -786486914801535807L;
    protected String m_InstanceClass;

    public String globalInfo() {
        return "Creates a new weka.core.Instance-derived object, with all values marked as missing.\nThe class implementing the weka.core.Instance interface needs to have a constructor that takes the number of attributes as sole parameter.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("instance-class", "instanceClass", (Object)DenseInstance.class.getName());
    }

    public void setInstanceClass(String value) {
        try {
            Class.forName(value);
            this.m_InstanceClass = value;
            this.reset();
        }
        catch (Exception e) {
            this.handleException("Failed to instantiate class '" + value + "' - ignored!", e);
        }
    }

    public String getInstanceClass() {
        return this.m_InstanceClass;
    }

    public String instanceClassTipText() {
        return "The full class name of the weka.core.Instance-derived object to instantiate.";
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("instance");
        if (variable != null) {
            return variable;
        }
        return this.m_InstanceClass;
    }

    public Class[] accepts() {
        return new Class[]{Instances.class};
    }

    public Class[] generates() {
        return new Class[]{Instance.class};
    }

    protected String doExecute() {
        String result = null;
        Instances data = (Instances)this.m_InputToken.getPayload();
        try {
            Class<?> cls = Class.forName(this.m_InstanceClass);
            Constructor<?> constr = cls.getConstructor(Integer.TYPE);
            Instance inst = (Instance)constr.newInstance(data.numAttributes());
            inst.setDataset(data);
            this.m_OutputToken = new Token((Object)inst);
        }
        catch (Exception e) {
            result = this.handleException("Failed to create new instance: ", e);
        }
        return result;
    }
}

