/*
 * Decompiled with CFR 0.152.
 */
package adams.data.weka;

import adams.core.Range;
import adams.core.RangeTest;
import adams.data.weka.WekaAttributeRange;
import adams.env.Environment;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.core.Attribute;
import weka.core.Instances;
import weka.core.converters.ConverterUtils;

public class WekaAttributeRangeTest
extends RangeTest {
    protected Instances m_Data;

    public WekaAttributeRangeTest(String name) {
        super(name);
    }

    protected AbstractTestHelper newTestHelper() {
        return new TestHelper((AdamsTestCase)this, "adams/data/weka/data");
    }

    protected void setUp() throws Exception {
        super.setUp();
        String filename = "labor.arff";
        this.m_TestHelper.copyResourceToTmp(filename);
        this.m_Data = ConverterUtils.DataSource.read((String)new TmpFile(filename).getAbsolutePath());
        if (this.m_Data == null) {
            throw new FileNotFoundException("Test file '" + filename + "' not found?");
        }
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("labor.arff");
        super.tearDown();
    }

    protected Range newRange(String index, int max) {
        if (index == null) {
            return new WekaAttributeRange();
        }
        return new WekaAttributeRange(index, max);
    }

    public void testColumnNames() {
        WekaAttributeRange range = new WekaAttributeRange();
        range = new WekaAttributeRange("first-last");
        WekaAttributeRangeTest.assertEquals((String)"should contain no indices", (int)0, (int)range.getIntIndices().length);
        WekaAttributeRangeTest.assertEquals((String)"should be same", (String)"first-last", (String)range.getRange());
        range.setData(null);
        range.setRange("blah");
        WekaAttributeRangeTest.assertEquals((String)"should contain no indices", (int)0, (int)range.getIntIndices().length);
        WekaAttributeRangeTest.assertEquals((String)"should be same", (String)"blah", (String)range.getRange());
        range.setData((Object)this.m_Data);
        range.setRange("duration");
        WekaAttributeRangeTest.assertEquals((String)"should be valid", (int)1, (int)range.getIntIndices().length);
        WekaAttributeRangeTest.assertEquals((String)"should be valid", (int)0, (int)range.getIntIndices()[0]);
        WekaAttributeRangeTest.assertEquals((String)"should be same", (String)"duration", (String)range.getRange());
        range.setData((Object)this.m_Data);
        range.setRange("Duration");
        WekaAttributeRangeTest.assertEquals((String)"should be valid", (int)1, (int)range.getIntIndices().length);
        WekaAttributeRangeTest.assertEquals((String)"should be valid", (int)0, (int)range.getIntIndices()[0]);
        WekaAttributeRangeTest.assertEquals((String)"should be same", (String)"duration", (String)range.getRange());
        range.setData((Object)this.m_Data);
        range.setRange("duratoin");
        WekaAttributeRangeTest.assertEquals((String)"should be invalid", (int)0, (int)range.getIntIndices().length);
        WekaAttributeRangeTest.assertEquals((String)"should be same", (String)"duratoin", (String)range.getRange());
        range.setData(null);
        range.setRange("class-duration");
        WekaAttributeRangeTest.assertEquals((String)"should be invalid", (int)0, (int)range.getIntIndices().length);
        WekaAttributeRangeTest.assertEquals((String)"should be same", (String)"class-duration", (String)range.getRange());
        range.setData((Object)this.m_Data);
        range.setRange("duration-class");
        WekaAttributeRangeTest.assertEquals((String)"should be valid", (int)17, (int)range.getIntIndices().length);
        WekaAttributeRangeTest.assertEquals((String)"should be same", (String)"duration-class", (String)range.getRange());
        for (int i = 0; i < this.m_Data.numAttributes(); ++i) {
            WekaAttributeRangeTest.assertEquals((String)"should be valid", (int)i, (int)range.getIntIndices()[i]);
        }
    }

    public void testSpecialColumnNames() {
        WekaAttributeRange range = new WekaAttributeRange();
        range.setData((Object)this.m_Data);
        range.setRange("\"shift-differential\"");
        WekaAttributeRangeTest.assertEquals((String)"should be valid", (int)1, (int)range.getIntIndices().length);
        WekaAttributeRangeTest.assertEquals((String)"should be valid", (int)8, (int)range.getIntIndices()[0]);
        WekaAttributeRangeTest.assertEquals((String)"should be same", (String)"\"shift-differential\"", (String)range.getRange());
    }

    public void testSubstrings() {
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        atts.add(new Attribute("blah"));
        atts.add(new Attribute("dbtimestamp"));
        atts.add(new Attribute("time"));
        Instances data = new Instances("test", atts, 0);
        WekaAttributeRange range = new WekaAttributeRange();
        range.setRange("bloerk");
        range.setData((Object)data);
        WekaAttributeRangeTest.assertEquals((String)"shouldn't find any cols", (int)0, (int)range.getIntIndices().length);
        range = new WekaAttributeRange();
        range.setRange("dbtimestamp");
        range.setData((Object)data);
        WekaAttributeRangeTest.assertEquals((String)"index differs", (int)1, (int)range.getIntIndices()[0]);
        range = new WekaAttributeRange();
        range.setRange("time");
        range.setData((Object)data);
        WekaAttributeRangeTest.assertEquals((String)"# indices differs", (int)1, (int)range.getIntIndices().length);
        WekaAttributeRangeTest.assertEquals((String)"index differs", (int)2, (int)range.getIntIndices()[0]);
        range = new WekaAttributeRange();
        range.setRange("blah");
        range.setData((Object)data);
        WekaAttributeRangeTest.assertEquals((String)"# indices differs", (int)1, (int)range.getIntIndices().length);
        WekaAttributeRangeTest.assertEquals((String)"index differs", (int)0, (int)range.getIntIndices()[0]);
    }

    public static Test suite() {
        return new TestSuite(WekaAttributeRangeTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        WekaAttributeRangeTest.runTest((Test)WekaAttributeRangeTest.suite());
    }
}

