/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.CallableActorReference;
import adams.flow.sink.DumpFile;
import adams.flow.source.FileSupplier;
import adams.flow.source.SequenceSource;
import adams.flow.source.WekaClassifierSetup;
import adams.flow.standalone.CallableActors;
import adams.flow.transformer.WekaClassSelector;
import adams.flow.transformer.WekaEvaluationSummary;
import adams.flow.transformer.WekaFileReader;
import adams.flow.transformer.WekaTestSetEvaluator;
import adams.flow.transformer.WekaTrainClassifier;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.classifiers.Classifier;
import weka.classifiers.trees.J48;

public class WekaTestSetEvaluatorTest
extends AbstractFlowTest {
    public WekaTestSetEvaluatorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public AbstractActor getActor() {
        FileSupplier sfstest = new FileSupplier();
        sfstest.setFiles(new PlaceholderFile[]{new TmpFile("vote.arff")});
        WekaFileReader frtest = new WekaFileReader();
        WekaClassSelector cstest = new WekaClassSelector();
        SequenceSource seqs = new SequenceSource();
        seqs.setName("test");
        seqs.setActors(new AbstractActor[]{sfstest, frtest, cstest});
        WekaClassifierSetup wcs = new WekaClassifierSetup();
        wcs.setName("cls");
        wcs.setClassifier((Classifier)new J48());
        CallableActors ga = new CallableActors();
        ga.setActors(new AbstractActor[]{seqs, wcs});
        FileSupplier sfs = new FileSupplier();
        sfs.setFiles(new PlaceholderFile[]{new TmpFile("vote.arff")});
        WekaFileReader fr = new WekaFileReader();
        WekaClassSelector cs = new WekaClassSelector();
        WekaTrainClassifier cls = new WekaTrainClassifier();
        cls.setClassifier(new CallableActorReference("cls"));
        WekaTestSetEvaluator tse = new WekaTestSetEvaluator();
        tse.setTestset(new CallableActorReference("test"));
        WekaEvaluationSummary eval = new WekaEvaluationSummary();
        DumpFile df = new DumpFile();
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{ga, sfs, fr, cs, cls, tse, eval, df});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.txt"));
    }

    public static Test suite() {
        return new TestSuite(WekaTestSetEvaluatorTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        WekaTestSetEvaluatorTest.runTest((Test)WekaTestSetEvaluatorTest.suite());
    }
}

