/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.Utils;
import adams.data.conversion.AbstractConversion;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.env.Environment;
import adams.ml.data.Dataset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;

public class SpreadSheetToWekaInstances
extends AbstractConversion {
    private static final long serialVersionUID = 867886761713927179L;
    protected int m_MaxLabels;

    public String globalInfo() {
        return "Generates a " + Instances.class.getName() + " object from a " + "SpreadSheet object.\n" + "If there are too many unique lables for a NOMINAL attribute, it gets " + "turned into a STRING attribute (see 'maxLabels' property).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("max-labels", "maxLabels", (Object)25, (Number)1, null);
    }

    public void setMaxLabels(int value) {
        this.m_MaxLabels = value;
        this.reset();
    }

    public int getMaxLabels() {
        return this.m_MaxLabels;
    }

    public String maxLabelsTipText() {
        return "The maximum number of labels that a NOMINAL attribute can have before it is switched to a STRING attribute.";
    }

    public Class accepts() {
        return SpreadSheet.class;
    }

    public Class generates() {
        return Instances.class;
    }

    protected Object doConvert() throws Exception {
        int[] classIndices;
        Cell cell;
        DataRow row;
        int n;
        int i;
        SpreadSheet sheet = (SpreadSheet)this.m_Input;
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        for (i = 0; i < sheet.getColumnCount(); ++i) {
            boolean added = false;
            Collection types = sheet.getContentTypes(i);
            if (types.contains(Cell.ContentType.DOUBLE)) {
                types.remove(Cell.ContentType.LONG);
            }
            if (types.contains(Cell.ContentType.LONG)) {
                types.add(Cell.ContentType.DOUBLE);
                types.remove(Cell.ContentType.LONG);
            }
            if (types.size() == 1) {
                Cell.ContentType type = (Cell.ContentType)types.toArray()[0];
                if (type == Cell.ContentType.DOUBLE) {
                    atts.add(new Attribute(sheet.getHeaderRow().getCell(i).getContent()));
                    added = true;
                } else if (type == Cell.ContentType.DATE) {
                    atts.add(new Attribute(sheet.getHeaderRow().getCell(i).getContent(), "yyyy-MM-dd HH:mm:ss"));
                    added = true;
                } else if (type == Cell.ContentType.TIME) {
                    atts.add(new Attribute(sheet.getHeaderRow().getCell(i).getContent(), "HH:mm:ss"));
                    added = true;
                }
            }
            if (added) continue;
            HashSet<String> unique = new HashSet<String>();
            for (n = 0; n < sheet.getRowCount(); ++n) {
                row = sheet.getRow(n);
                cell = row.getCell(i);
                if (cell == null || cell.isMissing()) continue;
                unique.add(cell.getContent());
            }
            if (unique.size() > this.m_MaxLabels) {
                atts.add(new Attribute(sheet.getHeaderRow().getCell(i).getContent(), (List)((FastVector)null)));
                continue;
            }
            ArrayList labels = new ArrayList(unique);
            Collections.sort(labels);
            atts.add(new Attribute(sheet.getHeaderRow().getCell(i).getContent(), labels));
        }
        Instances result = new Instances(Environment.getInstance().getProject(), atts, sheet.getRowCount());
        if (sheet.hasName()) {
            result.setRelationName(sheet.getName());
        }
        for (n = 0; n < sheet.getRowCount(); ++n) {
            row = sheet.getRow(n);
            double[] values = new double[result.numAttributes()];
            for (i = 0; i < result.numAttributes(); ++i) {
                cell = row.getCell(i);
                values[i] = weka.core.Utils.missingValue();
                if (cell == null || cell.isMissing()) continue;
                if (result.attribute(i).type() == 3) {
                    if (cell.isTime()) {
                        values[i] = cell.toTime().getTime();
                        continue;
                    }
                    values[i] = cell.toDate().getTime();
                    continue;
                }
                values[i] = result.attribute(i).isNumeric() ? Utils.toDouble((String)cell.getContent()) : (result.attribute(i).isString() ? (double)result.attribute(i).addStringValue(cell.getContent()) : (double)result.attribute(i).indexOfValue(cell.getContent()));
            }
            DenseInstance inst = new DenseInstance(1.0, values);
            result.add((Instance)inst);
        }
        if (sheet instanceof Dataset && (classIndices = ((Dataset)sheet).getClassAttributeIndices()).length > 0) {
            result.setClassIndex(classIndices[0]);
        }
        return result;
    }
}

