/*
 * Decompiled with CFR 0.152.
 */
package adams.genetic;

import adams.core.Properties;
import adams.core.SerializationHelper;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionUtils;
import adams.event.FitnessChangeEvent;
import adams.event.FitnessChangeListener;
import adams.event.FitnessChangeNotifier;
import adams.genetic.MTAbstractGeneticAlgorithm;
import adams.multiprocess.Job;
import adams.multiprocess.JobList;
import adams.multiprocess.JobRunner;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;
import java.util.logging.Level;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.rules.ZeroR;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.UnassignedClassException;
import weka.filters.unsupervised.attribute.Remove;

public class DarkLord
extends MTAbstractGeneticAlgorithm
implements FitnessChangeNotifier {
    private static final long serialVersionUID = 4822397823362084867L;
    protected int m_BitsPerGene;
    protected Instances m_Instances;
    protected PlaceholderFile m_Dataset;
    protected PlaceholderFile m_SerializedModel;
    protected Classifier m_Classifier;
    protected PlaceholderDirectory m_OutputDirectory;
    protected int m_Folds;
    protected int m_CrossValidationSeed;
    protected double m_BestFitness;
    protected String m_ClassIndex;
    protected Measure m_Measure;
    protected int m_NotificationInterval;
    protected HashSet<FitnessChangeListener> m_FitnessChangeListeners;
    protected Long m_LastNotificationTime;
    public static Hashtable<String, Double> m_StoredResults = new Hashtable();

    protected static synchronized void addResult(String key, Double val) {
        m_StoredResults.put(key, val);
    }

    protected static synchronized Double getResult(String key) {
        Double res = m_StoredResults.get(key);
        return res;
    }

    protected static synchronized void clearResults() {
        m_StoredResults.clear();
    }

    @Override
    public Vector<int[]> getInitialSetups() {
        return new Vector<int[]>();
    }

    public String globalInfo() {
        return "The Dark Lord.";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_BestFitness = Double.NEGATIVE_INFINITY;
        this.m_FitnessChangeListeners = new HashSet();
        this.m_LastNotificationTime = null;
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("bits-per-gene", "bitsPerGene", (Object)1);
        this.m_OptionManager.add("folds", "folds", (Object)10);
        this.m_OptionManager.add("cv-seed", "crossValidationSeed", (Object)55);
        this.m_OptionManager.add("serialized", "serializedModel", (Object)new PlaceholderFile("."));
        this.m_OptionManager.add("classifier", "classifier", (Object)new ZeroR());
        this.m_OptionManager.add("output-dir", "outputDirectory", (Object)new PlaceholderDirectory("."));
        this.m_OptionManager.add("dataset", "dataset", (Object)new PlaceholderFile("./data.arff"));
        this.m_OptionManager.add("class", "classIndex", (Object)"last");
        this.m_OptionManager.add("measure", "measure", (Object)Measure.RMSE);
        this.m_OptionManager.add("notify", "notificationInterval", (Object)-1);
    }

    public void setFolds(int value) {
        this.m_Folds = value;
        this.reset();
    }

    public int getFolds() {
        return this.m_Folds;
    }

    public String foldsTipText() {
        return "The number of folds to use in cross-validation.";
    }

    public void setCrossValidationSeed(int value) {
        this.m_CrossValidationSeed = value;
        this.reset();
    }

    public int getCrossValidationSeed() {
        return this.m_CrossValidationSeed;
    }

    public String crossValidationSeedTipText() {
        return "The seed value for cross-validation.";
    }

    public void setInstances(Instances value) {
        this.m_Instances = value;
    }

    public Instances getInstances() {
        return this.m_Instances;
    }

    public void setDataset(PlaceholderFile value) {
        this.m_Dataset = value;
        this.reset();
    }

    public PlaceholderFile getDataset() {
        return this.m_Dataset;
    }

    public String datasetTipText() {
        return "The dataset to use for cross-validation.";
    }

    public void setSerializedModel(PlaceholderFile value) {
        this.m_SerializedModel = value;
        this.reset();
    }

    public PlaceholderFile getSerializedModel() {
        return this.m_SerializedModel;
    }

    public String serializedModelTipText() {
        return "The filename for the serialized classifier.";
    }

    public void setClassifier(Classifier value) {
        this.m_Classifier = value;
        this.reset();
    }

    public Classifier getClassifier() {
        return this.m_Classifier;
    }

    public String classifierTipText() {
        return "The classifier to use if no serialized is supplied.";
    }

    public void setOutputDirectory(PlaceholderDirectory value) {
        this.m_OutputDirectory = value;
        this.reset();
    }

    public PlaceholderDirectory getOutputDirectory() {
        return this.m_OutputDirectory;
    }

    public String outputDirectoryTipText() {
        return "The directory for storing the generated ARFF files.";
    }

    public void setBitsPerGene(int value) {
        this.m_BitsPerGene = value;
        this.reset();
    }

    public int getBitsPerGene() {
        return this.m_BitsPerGene;
    }

    public String bitsPerGeneTipText() {
        return "The number of bits per gene to use.";
    }

    public void setClassIndex(String value) {
        this.m_ClassIndex = value;
        this.reset();
    }

    public String getClassIndex() {
        return this.m_ClassIndex;
    }

    public String classIndexTipText() {
        return "The class index of the dataset ('first' and 'last' are accepted as well).";
    }

    public void setMeasure(Measure value) {
        this.m_Measure = value;
        this.reset();
    }

    public Measure getMeasure() {
        return this.m_Measure;
    }

    public String measureTipText() {
        return "The measure used for evaluating the fitness.";
    }

    public void setNotificationInterval(int value) {
        this.m_NotificationInterval = value;
        this.reset();
    }

    public int getNotificationInterval() {
        return this.m_NotificationInterval;
    }

    public String notificationIntervalTipText() {
        return "The time interval in seconds after which notification events about changes in the fitness can be sent (-1 = never send notifications; 0 = whenever a change occurs).";
    }

    @Override
    public double getCurrentFitness() {
        return this.m_Measure.adjust(this.m_BestFitness);
    }

    protected synchronized boolean setNewFitness(double fitness) {
        boolean result = false;
        if (fitness > this.m_BestFitness) {
            this.m_BestFitness = fitness;
            result = true;
        }
        return result;
    }

    protected synchronized void notifyFitnessChangeListeners(double fitness) {
        if (this.m_NotificationInterval >= 0) {
            boolean notify;
            long currTime = System.currentTimeMillis();
            boolean bl = notify = this.m_NotificationInterval == 0 || this.m_NotificationInterval > 0 && this.m_LastNotificationTime == null || this.m_NotificationInterval > 0 && (double)(currTime - this.m_LastNotificationTime) / 1000.0 >= (double)this.m_NotificationInterval;
            if (notify) {
                this.m_LastNotificationTime = currTime;
                this.notifyFitnessChangeListeners(new FitnessChangeEvent(this, fitness));
            }
        }
    }

    @Override
    public void calcFitness() {
        int i;
        JobRunner runner = new JobRunner();
        JobList jobs = new JobList();
        for (i = 0; i < this.getNumChrom(); ++i) {
            int[] weights = new int[this.getNumGenes()];
            for (int j = 0; j < this.getNumGenes(); ++j) {
                int weight = 0;
                for (int k = 0; k < this.getBitsPerGene(); ++k) {
                    weight <<= 1;
                    if (!this.getGene(i, j * this.getBitsPerGene() + k)) continue;
                    ++weight;
                }
                weights[j] = weight;
            }
            jobs.add((Job)new DarkLordJob(this, i, weights));
        }
        runner.add(jobs);
        runner.start();
        runner.stop();
        for (i = 0; i < jobs.size(); ++i) {
            DarkLordJob job = (DarkLordJob)jobs.get(i);
            this.m_Fitness[job.getNumChrom()] = job.getFitness() == null ? Double.NEGATIVE_INFINITY : job.getFitness();
            job.cleanUp();
        }
    }

    @Override
    protected Properties storeSetup(Instances data, MTAbstractGeneticAlgorithm.GeneticAlgorithmJob job) {
        Properties result = super.storeSetup(data, job);
        DarkLordJob jobDL = (DarkLordJob)job;
        result.setProperty("mask", jobDL.getMaskAsString());
        Remove remove = new Remove();
        remove.setAttributeIndices(jobDL.getRemoveAsString());
        remove.setInvertSelection(true);
        result.setProperty("filter", OptionUtils.getCommandLine((Object)remove));
        return result;
    }

    @Override
    protected void preRun() {
        super.preRun();
        try {
            FileReader reader = new FileReader(this.m_Dataset.getAbsolutePath());
            this.m_Instances = new Instances((Reader)reader);
            reader.close();
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to read: " + this.m_Dataset, e);
            throw new IllegalStateException("Error loading dataset '" + this.m_Dataset + "': " + e);
        }
        int classIndex = this.m_ClassIndex.equals("first") ? 0 : (this.m_ClassIndex.equals("last") ? this.m_Instances.numAttributes() - 1 : Integer.parseInt(this.m_ClassIndex));
        this.m_Instances.setClassIndex(classIndex);
        if (!this.m_Measure.isValid(this.m_Instances)) {
            throw new IllegalArgumentException("Measure '" + (Object)((Object)this.m_Measure) + "' cannot process class of type '" + this.m_Instances.classAttribute().type() + "'!");
        }
        if (this.m_BestRange.getRange().length() != 0) {
            this.m_BestRange.setMax(this.m_Instances.numAttributes());
        }
        this.init(20, this.m_Instances.numAttributes() * this.m_BitsPerGene);
        this.m_LastNotificationTime = null;
        DarkLord.clearResults();
    }

    @Override
    public void addFitnessChangeListener(FitnessChangeListener l) {
        this.m_FitnessChangeListeners.add(l);
    }

    @Override
    public void removeFitnessChangeListener(FitnessChangeListener l) {
        this.m_FitnessChangeListeners.remove(l);
    }

    protected void notifyFitnessChangeListeners(FitnessChangeEvent e) {
        Iterator<FitnessChangeListener> iter = this.m_FitnessChangeListeners.iterator();
        while (iter.hasNext()) {
            iter.next().fitnessChanged(e);
        }
    }

    public String toString() {
        return super.toString() + "\n" + this.getCurrentFitness() + " (measure: " + (Object)((Object)this.getMeasure()) + ")";
    }

    public static enum Measure {
        CC(false, false, true),
        RMSE(true, true, true),
        RRSE(true, true, true),
        MAE(true, true, true),
        RAE(true, true, true),
        ACC(false, true, false);

        private boolean m_Negative;
        private boolean m_Nominal;
        private boolean m_Numeric;

        private Measure(boolean negative, boolean nominal, boolean numeric) {
            this.m_Negative = negative;
            this.m_Nominal = nominal;
            this.m_Numeric = numeric;
        }

        public double adjust(double measure) {
            if (this.m_Negative) {
                return -measure;
            }
            return measure;
        }

        public boolean isValid(Instances data) {
            if (data.classIndex() == -1) {
                throw new UnassignedClassException("No class attribute set!");
            }
            if (data.classAttribute().isNominal()) {
                return this.m_Nominal;
            }
            if (data.classAttribute().isNumeric()) {
                return this.m_Numeric;
            }
            throw new IllegalStateException("Class attribute '" + data.classAttribute().type() + "' not handled!");
        }
    }

    public static class DarkLordJob
    extends MTAbstractGeneticAlgorithm.GeneticAlgorithmJob {
        private static final long serialVersionUID = 8259167463381721274L;
        protected Measure m_Measure;

        public DarkLordJob(DarkLord g, int num, int[] w) {
            super(g, num, w);
            this.m_Measure = g.getMeasure();
        }

        public Measure getMeasure() {
            return this.m_Measure;
        }

        protected Instances getInstances() {
            return ((DarkLord)this.m_genetic).getInstances();
        }

        public String getMaskAsString() {
            String ret = "[";
            int pos = 0;
            int last = -1;
            boolean thefirst = true;
            for (int a = 0; a < this.getInstances().numAttributes(); ++a) {
                if (a == this.getInstances().classIndex()) continue;
                if (this.m_weights[a] == 0) {
                    if (last == -1) continue;
                    if (thefirst) {
                        thefirst = false;
                    } else {
                        ret = String.valueOf(ret) + ",";
                    }
                    ret = pos - last > 1 ? String.valueOf(ret) + last + "-" + pos : (pos - last == 1 ? String.valueOf(ret) + last + "," + pos : String.valueOf(ret) + last);
                    last = -1;
                }
                if (this.m_weights[a] == 0) continue;
                if (last == -1) {
                    last = a;
                }
                pos = a;
            }
            if (last != -1) {
                if (!thefirst) {
                    ret = String.valueOf(ret) + ",";
                }
                ret = pos - last > 1 ? String.valueOf(ret) + last + "-" + pos : (pos - last == 1 ? String.valueOf(ret) + last + "," + pos : String.valueOf(ret) + last);
            }
            return String.valueOf(ret) + "]";
        }

        public String getRemoveAsString() {
            String ret = "";
            int pos = 0;
            int last = -1;
            boolean thefirst = true;
            for (int a = 0; a < this.getInstances().numAttributes(); ++a) {
                if (this.m_weights[a] == 0 && a != this.getInstances().classIndex()) {
                    if (last == -1) continue;
                    if (thefirst) {
                        thefirst = false;
                    } else {
                        ret = String.valueOf(ret) + ",";
                    }
                    ret = pos - last > 1 ? String.valueOf(ret) + (last + 1) + "-" + (pos + 1) : (pos - last == 1 ? String.valueOf(ret) + (last + 1) + "," + (pos + 1) : String.valueOf(ret) + (last + 1));
                    last = -1;
                }
                if (this.m_weights[a] == 0 && a != this.getInstances().classIndex()) continue;
                if (last == -1) {
                    last = a;
                }
                pos = a;
            }
            if (last != -1) {
                if (!thefirst) {
                    ret = String.valueOf(ret) + ",";
                }
                ret = pos - last > 1 ? String.valueOf(ret) + (last + 1) + "-" + (pos + 1) : (pos - last == 1 ? String.valueOf(ret) + (last + 1) + "," + (pos + 1) : String.valueOf(ret) + (last + 1));
            }
            return ret;
        }

        @Override
        public void calcNewFitness() {
            try {
                this.getLogger().fine("calc for:" + this.weightsToString());
                Double cc = DarkLord.getResult(this.weightsToString());
                if (cc != null) {
                    this.getLogger().info("Already present: " + Double.toString(cc));
                    this.m_fitness = cc;
                    return;
                }
                int cnt = 0;
                Instances newInstances = new Instances(this.getInstances());
                for (int i = 0; i < this.getInstances().numInstances(); ++i) {
                    Instance in = newInstances.instance(i);
                    cnt = 0;
                    for (int a = 0; a < this.getInstances().numAttributes(); ++a) {
                        if (a == this.getInstances().classIndex()) continue;
                        if (this.m_weights[cnt++] == 0) {
                            in.setValue(a, 0.0);
                            continue;
                        }
                        in.setValue(a, in.value(a));
                    }
                }
                Classifier newClassifier = null;
                PlaceholderFile model = ((DarkLord)this.m_genetic).getSerializedModel();
                newClassifier = model.isDirectory() || !model.exists() ? AbstractClassifier.makeCopy((Classifier)((DarkLord)this.m_genetic).getClassifier()) : (Classifier)SerializationHelper.read((String)((DarkLord)this.m_genetic).getSerializedModel().getAbsolutePath());
                Evaluation evaluation = new Evaluation(newInstances);
                evaluation.crossValidateModel(newClassifier, newInstances, ((DarkLord)this.m_genetic).getFolds(), new Random(((DarkLord)this.m_genetic).getCrossValidationSeed()), new Object[0]);
                double measure = 0.0;
                if (this.getMeasure() == Measure.ACC) {
                    measure = evaluation.pctCorrect();
                } else if (this.getMeasure() == Measure.CC) {
                    measure = evaluation.correlationCoefficient();
                } else if (this.getMeasure() == Measure.MAE) {
                    measure = evaluation.meanAbsoluteError();
                } else if (this.getMeasure() == Measure.RAE) {
                    measure = evaluation.relativeAbsoluteError();
                } else if (this.getMeasure() == Measure.RMSE) {
                    measure = evaluation.rootMeanSquaredError();
                } else if (this.getMeasure() == Measure.RRSE) {
                    measure = evaluation.rootRelativeSquaredError();
                } else {
                    throw new IllegalStateException("Unhandled measure '" + (Object)((Object)this.getMeasure()) + "'!");
                }
                measure = this.getMeasure().adjust(measure);
                this.m_fitness = measure;
                if (((DarkLord)this.m_genetic).setNewFitness(this.m_fitness)) {
                    File file = new File(((DarkLord)this.m_genetic).getOutputDirectory().getAbsolutePath() + File.separator + Double.toString(this.getMeasure().adjust(measure)) + ".arff");
                    file.createNewFile();
                    BufferedWriter writer = new BufferedWriter(new FileWriter(file));
                    Instances header = new Instances(newInstances, 0);
                    header = this.m_genetic.updateHeader(header, this);
                    writer.write(header.toString());
                    writer.write("\n");
                    for (int i = 0; i < newInstances.numInstances(); ++i) {
                        writer.write(newInstances.instance(i).toString());
                        writer.write("\n");
                    }
                    ((Writer)writer).flush();
                    ((Writer)writer).close();
                    ((DarkLord)this.m_genetic).notifyFitnessChangeListeners(this.getMeasure().adjust(measure));
                } else {
                    this.getLogger().fine(this.getMaskAsString());
                }
                DarkLord.addResult(this.weightsToString(), this.m_fitness);
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Error: ", e);
                this.m_fitness = null;
            }
        }

        @Override
        protected String preProcessCheck() {
            String result = super.preProcessCheck();
            if (result == null && this.getInstances() == null) {
                result = "Null instances, which is poor..";
            }
            return result;
        }
    }
}

