/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import weka.classifiers.RangeCheckClassifier;
import weka.classifiers.RangeCheckHelper;
import weka.classifiers.SingleClassifierEnhancer;
import weka.core.AttributeStats;
import weka.core.Instance;
import weka.core.Instances;

public class RangeCheck
extends SingleClassifierEnhancer
implements RangeCheckClassifier {
    private static final long serialVersionUID = 735384379601515402L;
    protected Hashtable<Integer, double[]> m_Ranges = new Hashtable();
    protected Instances m_Header;

    public String globalInfo() {
        return "Keeps track of the ranges in case of numeric attributes. It then allows checks whether an instance is for one or more attributes outside the training range.";
    }

    public void buildClassifier(Instances data) throws Exception {
        data = new Instances(data);
        data.deleteWithMissingClass();
        this.m_Header = null;
        this.m_Ranges.clear();
        for (int i = 0; i < data.numAttributes(); ++i) {
            if (!data.attribute(i).isNumeric() || i == data.classIndex()) continue;
            AttributeStats stats = data.attributeStats(i);
            double[] range = new double[]{stats.numericStats.min, stats.numericStats.max};
            this.m_Ranges.put(i, range);
        }
        this.getClassifier().getCapabilities().testWithFail(data);
        this.m_Classifier.buildClassifier(data);
        if (this.m_Ranges.size() > 0) {
            this.m_Header = new Instances(data, 0);
        }
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        return this.m_Classifier.distributionForInstance(instance);
    }

    @Override
    public List<String> checkRangeForInstance(Instance inst) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < inst.numAttributes(); ++i) {
            double[] range;
            String msg;
            if (!inst.attribute(i).isNumeric() || i == inst.classIndex() || (msg = RangeCheckHelper.isOutside(inst, i, (range = this.m_Ranges.get(i))[0], range[1])) == null) continue;
            result.add(msg);
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.m_Header != null && this.m_Ranges.size() > 0) {
            ArrayList<Integer> indices = new ArrayList<Integer>(this.m_Ranges.keySet());
            Collections.sort(indices);
            result.append("Recorded ranges\n");
            result.append("---------------\n\n");
            for (Integer index : indices) {
                double[] range = this.m_Ranges.get(index);
                result.append(this.m_Header.attribute(index.intValue()).name() + ": [" + range[0] + "," + range[1] + "]");
                result.append("\n");
            }
            result.append("\n");
        }
        result.append(this.m_Classifier.toString());
        return result.toString();
    }
}

