/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.experiment.ext;

import adams.core.Properties;
import adams.core.StatusMessageHandler;
import adams.core.Utils;
import adams.gui.chooser.BaseFileChooser;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseStatusBar;
import adams.gui.core.BaseTabbedPane;
import adams.gui.core.ConsolePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.core.RecentFilesHandler;
import adams.gui.core.TitleGenerator;
import adams.gui.event.RecentItemEvent;
import adams.gui.event.RecentItemListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import weka.core.Instances;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.ConverterUtils;
import weka.experiment.Experiment;
import weka.gui.ConverterFileChooser;
import weka.gui.experiment.ext.AbstractExperimentRunner;
import weka.gui.experiment.ext.AbstractSetupPanel;
import weka.gui.experiment.ext.AnalysisPanel;
import weka.gui.experiment.ext.BasicSetupPanel;
import weka.gui.experiment.ext.LogPanel;

public class ExperimenterPanel
extends BasePanel
implements MenuBarProvider,
StatusMessageHandler {
    private static final long serialVersionUID = 7314544066929763500L;
    public static final String SESSION_FILE = "ExperimenterExtSession.props";
    public static final String FILENAME = "weka/gui/experiment/ext/ExperimenterExt.props";
    protected static Properties m_Properties;
    protected RecentFilesHandler<JMenu> m_RecentFilesHandlerSetups;
    protected RecentFilesHandler<JMenu> m_RecentFilesHandlerResults;
    protected JMenuBar m_MenuBar;
    protected JMenu m_MenuItemFileLoadRecent;
    protected JMenuItem m_MenuItemFileSave;
    protected JMenuItem m_MenuItemFileSaveAs;
    protected JMenuItem m_MenuItemExecutionStart;
    protected JMenuItem m_MenuItemExecutionStop;
    protected JMenu m_MenuItemResultsLoadRecent;
    protected JMenuItem m_MenuItemResultsSave;
    protected BaseStatusBar m_StatusBar;
    protected File m_CurrentFile;
    protected TitleGenerator m_TitleGenerator;
    protected BaseTabbedPane m_TabbedPane;
    protected AbstractSetupPanel m_PanelSetup;
    protected AnalysisPanel m_PanelAnalysis;
    protected LogPanel m_PanelLog;
    protected Experiment m_Experiment;
    protected ConverterFileChooser m_FileChooserResults;
    protected AbstractExperimentRunner m_Runner;

    protected void initialize() {
        super.initialize();
        this.m_RecentFilesHandlerSetups = null;
        this.m_RecentFilesHandlerResults = null;
        this.m_TitleGenerator = new TitleGenerator("Experimenter", true);
        this.m_Experiment = null;
        this.m_FileChooserResults = new ConverterFileChooser();
        this.m_Runner = null;
    }

    protected void initGUI() {
        super.initGUI();
        this.m_TabbedPane = new BaseTabbedPane();
        this.add((Component)this.m_TabbedPane, "Center");
        this.m_PanelSetup = new BasicSetupPanel();
        this.m_PanelSetup.setOwner(this);
        this.m_TabbedPane.addTab("Setup", (Component)((Object)this.m_PanelSetup));
        this.m_PanelAnalysis = new AnalysisPanel();
        this.m_PanelAnalysis.setOwner(this);
        this.m_TabbedPane.addTab("Analysis", (Component)((Object)this.m_PanelAnalysis));
        this.m_PanelLog = new LogPanel();
        this.m_PanelLog.setOwner(this);
        this.m_TabbedPane.addTab("Log", (Component)((Object)this.m_PanelLog));
        this.m_StatusBar = new BaseStatusBar();
        this.add((Component)this.m_StatusBar, "South");
    }

    protected void finishInit() {
        super.finishInit();
        this.update();
    }

    public void close() {
        GUIHelper.closeParent((Container)((Object)this));
    }

    public void newSetup(AbstractSetupPanel setup) {
        AbstractSetupPanel current = (AbstractSetupPanel)((Object)this.m_TabbedPane.getComponentAt(0));
        current.setOwner(null);
        setup.setOwner(this);
        this.m_TabbedPane.setComponentAt(0, (Component)((Object)setup));
        this.logMessage("New setup: " + ((Object)((Object)current)).getClass().getName());
    }

    public void openSetup() {
        BaseFileChooser filechooser = this.m_PanelSetup.getExperimentIO().getFileChooser();
        int retVal = filechooser.showOpenDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        if (this.m_RecentFilesHandlerSetups != null) {
            this.m_RecentFilesHandlerSetups.addRecentItem((Object)filechooser.getSelectedFile());
        }
        this.openSetup(filechooser.getSelectedFile());
        this.update();
    }

    public void openSetup(File file) {
        this.logMessage("Loading setup from " + file + "...");
        Object exp = this.m_PanelSetup.getExperimentIO().load(file);
        String msg = exp == null ? "Failed to load experiment" : this.m_PanelSetup.handlesExperiment(exp);
        if (msg == null) {
            this.m_PanelSetup.setExperiment(exp);
            this.m_PanelSetup.setModified(false);
            this.m_CurrentFile = file;
            this.update();
            this.logMessage("Loaded setup from " + file);
        } else {
            this.logError("Cannot handle experiment stored in " + file + "!\n" + msg, "Load experiment");
        }
    }

    public void openRecentSetup(RecentItemEvent<JMenu, File> e) {
        this.openSetup((File)e.getItem());
    }

    public void saveSetup() {
        if (this.m_CurrentFile == null) {
            this.saveSetupAs();
            return;
        }
        this.saveSetup(this.m_CurrentFile);
    }

    public void saveSetup(File file) {
        try {
            this.logMessage("Saving experiment to " + file);
            Experiment.write((String)file.getAbsolutePath(), (Experiment)this.getExperiment());
            this.m_PanelSetup.setModified(false);
            this.m_CurrentFile = file;
            if (this.m_RecentFilesHandlerSetups != null) {
                this.m_RecentFilesHandlerSetups.addRecentItem((Object)this.m_CurrentFile);
            }
            this.update();
            this.logMessage("Saved experiment to " + file);
        }
        catch (Exception e) {
            this.logError("Failed to save experiment to " + file + "!\n" + Utils.throwableToString((Throwable)e), "Save experiment");
        }
    }

    public void saveSetupAs() {
        BaseFileChooser filechooser = this.m_PanelSetup.getExperimentIO().getFileChooser();
        int retVal = filechooser.showSaveDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        this.saveSetup(filechooser.getSelectedFile());
    }

    public boolean isExecuting() {
        return this.m_Runner != null;
    }

    public void startExecution() {
        try {
            this.m_Runner = this.m_PanelSetup.getExperimentIO().createRunner(this);
        }
        catch (Exception e) {
            this.logError("Failed to run experiment: " + Utils.throwableToString((Throwable)e), "Execution error");
            return;
        }
        this.m_Runner.start();
    }

    public void stopExecution() {
        this.m_Runner.abortExperiment();
        this.update();
    }

    public void finishExecution() {
        this.m_Runner = null;
        this.update();
    }

    public void openResults() {
        int retVal = this.m_FileChooserResults.showOpenDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        if (this.m_RecentFilesHandlerResults != null) {
            this.m_RecentFilesHandlerSetups.addRecentItem((Object)this.m_FileChooserResults.getSelectedFile());
        }
        this.openResults(this.m_FileChooserResults.getSelectedFile());
        this.update();
    }

    public void openRecentResults(RecentItemEvent<JMenu, File> e) {
        this.openResults((File)e.getItem());
    }

    public void openResults(File file) {
        this.logMessage("Loading results " + file + "...");
        AbstractFileLoader loader = ConverterUtils.getLoaderForFile((File)file);
        if (loader == null) {
            this.logError("Failed to determine file loader for the following file:\n" + file, "Loading results");
            return;
        }
        try {
            loader.setFile(file);
            Instances results = loader.getDataSet();
            String msg = this.m_PanelAnalysis.handlesResults(results);
            if (msg == null) {
                this.m_PanelAnalysis.setResults(results);
            } else {
                this.logError("Cannot handle results from " + file + "\n" + msg, "Loading results");
            }
        }
        catch (Exception e) {
            String msg = "Failed to load results from " + file + "\n" + Utils.throwableToString((Throwable)e);
            this.logError("Cannot handle results from " + file + "\n" + msg, "Loading results");
        }
    }

    public void openResultsDB() {
    }

    public void saveResults() {
        int retVal = this.m_FileChooserResults.showSaveDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        this.saveResults(this.m_FileChooserResults.getSelectedFile(), this.m_FileChooserResults.getSaver());
    }

    public void saveResults(File file) {
        AbstractFileSaver saver = ConverterUtils.getSaverForFile((File)file);
        if (saver == null) {
            this.logError("Failed to determine file saver for " + file, "Saving results");
        } else {
            this.saveResults(file, saver);
        }
    }

    protected void saveResults(File file, AbstractFileSaver saver) {
        try {
            this.logMessage("Saving results to " + file + "...");
            saver.setInstances(this.m_PanelAnalysis.getResults());
            saver.writeBatch();
            this.logMessage("Results saved to " + file);
            if (this.m_RecentFilesHandlerResults != null) {
                this.m_RecentFilesHandlerResults.addRecentItem((Object)file);
            }
        }
        catch (Exception e) {
            this.logError("Failed to save results to " + file + "\n" + Utils.throwableToString((Throwable)e), "Saving results");
        }
    }

    public JMenuBar getMenuBar() {
        JMenuBar result;
        if (this.m_MenuBar == null) {
            JMenuItem menuitem;
            String[] classes;
            result = new JMenuBar();
            JMenu menu = new JMenu("File");
            result.add(menu);
            menu.setMnemonic('F');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ExperimenterPanel.this.updateMenu();
                }
            });
            JMenu submenu = new JMenu("New");
            menu.add(submenu);
            submenu.setMnemonic('N');
            for (String cls : classes = AbstractSetupPanel.getPanels()) {
                try {
                    final AbstractSetupPanel setup = (AbstractSetupPanel)((Object)Class.forName(cls).newInstance());
                    menuitem = new JMenuItem(setup.getSetupName());
                    if (setup instanceof BasicSetupPanel) {
                        menuitem.setIcon(GUIHelper.getIcon((String)"new.gif"));
                        menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed N"));
                    }
                    menuitem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ExperimenterPanel.this.newSetup(setup);
                        }
                    });
                    submenu.add(menuitem);
                }
                catch (Exception e) {
                    this.logError("Failed to instantiate experiment: " + cls + "\n" + Utils.throwableToString((Throwable)e), "New experiment");
                }
            }
            menuitem = new JMenuItem("Open...");
            menu.add(menuitem);
            menuitem.setMnemonic('o');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed O"));
            menuitem.setIcon(GUIHelper.getIcon((String)"open.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExperimenterPanel.this.openSetup();
                }
            });
            submenu = new JMenu("Open recent");
            menu.add(submenu);
            this.m_RecentFilesHandlerSetups = new RecentFilesHandler(SESSION_FILE, "Setup-", ExperimenterPanel.getProperties().getInteger("SetupsMaxRecent", Integer.valueOf(5)).intValue(), (Object)submenu);
            this.m_RecentFilesHandlerSetups.addRecentItemListener((RecentItemListener)new RecentItemListener<JMenu, File>(){

                public void recentItemAdded(RecentItemEvent<JMenu, File> e) {
                }

                public void recentItemSelected(RecentItemEvent<JMenu, File> e) {
                    ExperimenterPanel.this.openRecentSetup(e);
                }
            });
            this.m_MenuItemFileLoadRecent = submenu;
            menuitem = new JMenuItem("Save");
            menu.addSeparator();
            menu.add(menuitem);
            menuitem.setMnemonic('S');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed S"));
            menuitem.setIcon(GUIHelper.getIcon((String)"save.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExperimenterPanel.this.saveSetup();
                }
            });
            this.m_MenuItemFileSave = menuitem;
            menuitem = new JMenuItem("Save as...");
            menu.add(menuitem);
            menuitem.setMnemonic('a');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl shift pressed S"));
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExperimenterPanel.this.saveSetupAs();
                }
            });
            this.m_MenuItemFileSaveAs = menuitem;
            menuitem = new JMenuItem("Close");
            menu.addSeparator();
            menu.add(menuitem);
            menuitem.setMnemonic('C');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed Q"));
            menuitem.setIcon(GUIHelper.getIcon((String)"exit.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExperimenterPanel.this.close();
                }
            });
            menu = new JMenu("Execution");
            result.add(menu);
            menu.setMnemonic('E');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ExperimenterPanel.this.updateMenu();
                }
            });
            menuitem = new JMenuItem("Start");
            menu.add(menuitem);
            menuitem.setMnemonic('S');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed R"));
            menuitem.setIcon(GUIHelper.getIcon((String)"run.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExperimenterPanel.this.startExecution();
                }
            });
            this.m_MenuItemExecutionStart = menuitem;
            menuitem = new JMenuItem("Stop");
            menu.add(menuitem);
            menuitem.setMnemonic('p');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed K"));
            menuitem.setIcon(GUIHelper.getIcon((String)"stop_blue.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExperimenterPanel.this.stopExecution();
                }
            });
            this.m_MenuItemExecutionStop = menuitem;
            menu = new JMenu("Analysis");
            result.add(menu);
            menu.setMnemonic('A');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ExperimenterPanel.this.updateMenu();
                }
            });
            menuitem = new JMenuItem("Open...");
            menu.add(menuitem);
            menuitem.setMnemonic('O');
            menuitem.setIcon(GUIHelper.getIcon((String)"open.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExperimenterPanel.this.openResults();
                }
            });
            submenu = new JMenu("Open recent");
            menu.add(submenu);
            this.m_RecentFilesHandlerResults = new RecentFilesHandler(SESSION_FILE, "Results-", ExperimenterPanel.getProperties().getInteger("ResultsMaxRecent", Integer.valueOf(5)).intValue(), (Object)submenu);
            this.m_RecentFilesHandlerResults.addRecentItemListener((RecentItemListener)new RecentItemListener<JMenu, File>(){

                public void recentItemAdded(RecentItemEvent<JMenu, File> e) {
                }

                public void recentItemSelected(RecentItemEvent<JMenu, File> e) {
                    ExperimenterPanel.this.openRecentResults(e);
                }
            });
            this.m_MenuItemResultsLoadRecent = submenu;
            menuitem = new JMenuItem("Open DB...");
            menu.add(menuitem);
            menuitem.setMnemonic('D');
            menuitem.setIcon(GUIHelper.getIcon((String)"database.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExperimenterPanel.this.openResultsDB();
                }
            });
            menuitem = new JMenuItem("Save...");
            menu.addSeparator();
            menu.add(menuitem);
            menuitem.setMnemonic('S');
            menuitem.setIcon(GUIHelper.getIcon((String)"save.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExperimenterPanel.this.saveResults();
                }
            });
            this.m_MenuItemResultsSave = menuitem;
            this.m_MenuBar = result;
            this.updateMenu();
        } else {
            result = this.m_MenuBar;
        }
        return result;
    }

    public void update() {
        this.updateTitle();
        this.updateMenu();
    }

    public TitleGenerator getTitleGenerator() {
        return this.m_TitleGenerator;
    }

    protected void updateTitle() {
        if (!this.m_TitleGenerator.isEnabled()) {
            return;
        }
        String title = this.m_TitleGenerator.generate(this.m_CurrentFile, this.m_PanelSetup.isModified());
        this.setParentTitle(title);
    }

    protected void updateMenu() {
        if (this.m_MenuBar == null) {
            return;
        }
        this.m_MenuItemFileSave.setEnabled(this.m_PanelSetup.isModified());
        this.m_MenuItemExecutionStart.setEnabled(!this.isExecuting());
        this.m_MenuItemExecutionStop.setEnabled(this.isExecuting());
        this.m_MenuItemResultsSave.setEnabled(this.m_PanelAnalysis.hasResults());
    }

    public void setTitle(String value) {
        this.m_TitleGenerator.setTitle(value);
        this.update();
    }

    public String getTitle() {
        return this.m_TitleGenerator.getTitle();
    }

    public Experiment getExperiment() {
        return this.m_PanelSetup.getExperiment();
    }

    public void setExperiment(Experiment value) {
        this.m_PanelSetup.setExperiment(value);
    }

    public String handlesExperiment(Experiment exp) {
        return this.m_PanelSetup.handlesExperiment(exp);
    }

    public void logMessage(Throwable t) {
        this.logMessage(Utils.throwableToString((Throwable)t));
    }

    public void logMessage(String msg) {
        this.m_PanelLog.append(msg);
    }

    public void logError(Throwable t, String title) {
        this.logError(Utils.throwableToString((Throwable)t), title);
    }

    public void logError(String msg, String title) {
        this.m_PanelLog.append(msg);
        GUIHelper.showErrorMessage((Component)((Object)this), (String)msg, (String)title);
    }

    public void showStatus(String msg) {
        this.m_StatusBar.showStatus(msg);
    }

    public static synchronized Properties getProperties() {
        if (m_Properties == null) {
            try {
                m_Properties = Properties.read((String)FILENAME);
            }
            catch (Exception e) {
                String msg = "Failed to load weka/gui/experiment/ext/ExperimenterExt.props\n" + Utils.throwableToString((Throwable)e);
                ConsolePanel.getSingleton().append(ConsolePanel.OutputType.ERROR, msg);
                System.err.println(msg);
                m_Properties = new Properties();
            }
        }
        return m_Properties;
    }
}

