/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.CallableActorReference;
import adams.flow.sink.WekaModelWriter;
import adams.flow.source.FileSupplier;
import adams.flow.source.WekaClassifierSetup;
import adams.flow.standalone.CallableActors;
import adams.flow.transformer.WekaClassSelector;
import adams.flow.transformer.WekaFileReader;
import adams.flow.transformer.WekaTrainClassifier;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.classifiers.Classifier;
import weka.classifiers.functions.SMO;

public class WekaModelWriterTest
extends AbstractFlowTest {
    public WekaModelWriterTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.model");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.model");
        super.tearDown();
    }

    public AbstractActor getActor() {
        WekaClassifierSetup cls = new WekaClassifierSetup();
        cls.setName("cls");
        cls.setClassifier((Classifier)new SMO());
        CallableActors ga = new CallableActors();
        ga.setActors(new AbstractActor[]{cls});
        FileSupplier sfs = new FileSupplier();
        sfs.setFiles(new PlaceholderFile[]{new TmpFile("vote.arff")});
        WekaFileReader fr = new WekaFileReader();
        fr.setOutputType(WekaFileReader.OutputType.DATASET);
        WekaClassSelector cs = new WekaClassSelector();
        WekaTrainClassifier wtc = new WekaTrainClassifier();
        wtc.setClassifier(new CallableActorReference("cls"));
        WekaModelWriter mw = new WekaModelWriter();
        mw.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.model"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{ga, sfs, fr, cs, wtc, mw});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.model"));
    }

    public static Test suite() {
        return new TestSuite(WekaModelWriterTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        WekaModelWriterTest.runTest((Test)WekaModelWriterTest.suite());
    }
}

