/*
 * Decompiled with CFR 0.152.
 */
package adams.core.discovery;

import adams.core.Utils;
import adams.core.discovery.AbstractGeneticDiscoveryHandler;
import adams.core.discovery.NumericValueType;
import adams.data.statistics.StatUtils;

public abstract class AbstractGeneticDoubleDiscoveryHandler
extends AbstractGeneticDiscoveryHandler {
    private static final long serialVersionUID = -5442076178374142588L;
    protected NumericValueType m_Type;
    protected double m_Minimum;
    protected double m_Maximum;
    protected double[] m_List;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)this.getDefaultType());
        this.m_OptionManager.add("minimum", "minimum", (Object)this.getDefaultMinimum());
        this.m_OptionManager.add("maximum", "maximum", (Object)this.getDefaultMaximum());
        this.m_OptionManager.add("list", "list", (Object)this.getDefaultList());
    }

    protected NumericValueType getDefaultType() {
        return NumericValueType.RANGE;
    }

    public void setType(NumericValueType value) {
        this.m_Type = value;
        this.reset();
    }

    public NumericValueType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of value to use.";
    }

    protected abstract double getDefaultMinimum();

    public void setMinimum(double value) {
        if (this.getOptionManager().isValid("minimum", (Number)value)) {
            this.m_Minimum = value;
            this.reset();
        }
    }

    public double getMinimum() {
        return this.m_Minimum;
    }

    public String minimumTipText() {
        return "The minimum to use.";
    }

    protected abstract double getDefaultMaximum();

    public void setMaximum(double value) {
        if (this.getOptionManager().isValid("maximum", (Number)value)) {
            this.m_Maximum = value;
            this.reset();
        }
    }

    public double getMaximum() {
        return this.m_Maximum;
    }

    public String maximumTipText() {
        return "The maximum to use.";
    }

    protected abstract String getDefaultList();

    public void setList(String value) {
        String[] parts = value.replaceAll("  ", " ").split(" ");
        double[] list = new double[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            try {
                list[i] = Double.parseDouble(parts[i]);
                continue;
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to parse '" + parts[i] + "' from list: " + value);
                return;
            }
        }
        this.m_List = list;
        this.reset();
    }

    public String getList() {
        return Utils.flatten((Object[])StatUtils.toNumberArray((double[])this.m_List), (String)" ");
    }

    public String listTipText() {
        return "The list to values to use.";
    }
}

