/*
 * Decompiled with CFR 0.152.
 */
package adams.core.discovery;

import adams.core.Utils;
import adams.core.discovery.AbstractGeneticDoubleDiscoveryHandler;
import adams.core.discovery.GeneticHelper;
import adams.core.discovery.PropertyPath;

public abstract class AbstractGeneticDoubleDiscoveryHandlerResolution
extends AbstractGeneticDoubleDiscoveryHandler {
    private static final long serialVersionUID = -4401650612139991644L;
    protected int m_Splits;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("splits", "splits", (Object)this.getDefaultSplits());
    }

    protected abstract int getDefaultSplits();

    public void setSplits(int value) {
        if (this.getOptionManager().isValid("splits", (Number)value)) {
            this.m_Splits = value;
            this.reset();
        }
    }

    public int getSplits() {
        return this.m_Splits;
    }

    public String splitsTipText() {
        return "The number of doubles to use between max and min.";
    }

    @Override
    public int getNumBits() {
        return this.calcNumBits();
    }

    protected int calcNumBits() {
        return (int)(Math.floor(Utils.log2((int)this.m_Splits)) + 1.0);
    }

    protected abstract double getValue(PropertyPath.PropertyContainer var1);

    @Override
    protected String doPack(PropertyPath.PropertyContainer cont) {
        double value = this.getValue(cont);
        switch (this.m_Type) {
            case RANGE: {
                return GeneticHelper.doubleToBits(value, this.getMinimum(), this.getMaximum(), this.calcNumBits(), this.getSplits());
            }
            case LIST: {
                int index = 0;
                for (int i = 0; i < this.m_List.length; ++i) {
                    if (this.m_List[i] != value) continue;
                    index = i;
                    break;
                }
                return GeneticHelper.intToBits(index, 0, this.m_List.length, this.calcNumBits());
            }
        }
        throw new IllegalStateException("Unhandled numeric value type: " + (Object)((Object)this.m_Type));
    }

    protected abstract void setValue(PropertyPath.PropertyContainer var1, double var2);

    @Override
    protected void doUnpack(PropertyPath.PropertyContainer cont, String bits) {
        switch (this.m_Type) {
            case RANGE: {
                this.setValue(cont, GeneticHelper.bitsToDouble(bits, this.getMinimum(), this.getMaximum(), this.getSplits()));
                break;
            }
            case LIST: {
                int index = GeneticHelper.bitsToInt(bits, 0, this.m_List.length);
                index = Math.max(0, index);
                index = Math.min(this.m_List.length - 1, index);
                this.setValue(cont, this.m_List[index]);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled numeric value type: " + (Object)((Object)this.m_Type));
            }
        }
    }
}

