/*
 * Decompiled with CFR 0.152.
 */
package adams.core.discovery;

import adams.core.Utils;
import adams.core.discovery.AbstractGeneticDiscoveryHandler;
import adams.core.discovery.GeneticHelper;
import adams.core.discovery.PropertyPath;

public abstract class AbstractGeneticIntegerArrayDiscoveryHandler
extends AbstractGeneticDiscoveryHandler {
    private static final long serialVersionUID = 765007046767066355L;
    protected int m_Minimum;
    protected int m_Maximum;
    protected int m_Size;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("minimum", "minimum", (Object)this.getDefaultMinimum());
        this.m_OptionManager.add("maximum", "maximum", (Object)this.getDefaultMaximum());
        this.m_OptionManager.add("size", "size", (Object)this.getDefaultSize());
    }

    protected abstract int getDefaultSize();

    protected abstract int getDefaultMinimum();

    public void setSize(int value) {
        if (this.getOptionManager().isValid("size", (Number)value)) {
            this.m_Size = value;
            this.reset();
        }
    }

    public int getSize() {
        return this.m_Size;
    }

    public String sizeTipText() {
        return "The size to use.";
    }

    public void setMinimum(int value) {
        if (this.getOptionManager().isValid("minimum", (Number)value)) {
            this.m_Minimum = value;
            this.reset();
        }
    }

    public int getMinimum() {
        return this.m_Minimum;
    }

    public String minimumTipText() {
        return "The minimum to use.";
    }

    protected abstract int getDefaultMaximum();

    public void setMaximum(int value) {
        if (this.getOptionManager().isValid("maximum", (Number)value)) {
            this.m_Maximum = value;
            this.reset();
        }
    }

    public int getMaximum() {
        return this.m_Maximum;
    }

    public String maximumTipText() {
        return "The maximum to use.";
    }

    protected abstract int[] getValue(PropertyPath.PropertyContainer var1);

    @Override
    protected String doPack(PropertyPath.PropertyContainer cont) {
        return GeneticHelper.intArrayToBits(this.getValue(cont), this.getMinimum(), this.getMaximum(), this.calcNumBits());
    }

    protected abstract void setValue(PropertyPath.PropertyContainer var1, int[] var2);

    @Override
    protected void doUnpack(PropertyPath.PropertyContainer cont, String bits) {
        this.setValue(cont, GeneticHelper.bitsToIntArray(bits, this.getMinimum(), this.getMaximum(), this.calcNumBits(), this.getSize()));
    }

    protected int calcNumBits() {
        int range = this.getMaximum() - this.getMinimum();
        return (int)(Math.floor(Utils.log2((int)range)) + 1.0);
    }

    @Override
    public int getNumBits() {
        return this.calcNumBits() * this.getSize();
    }
}

