/*
 * Decompiled with CFR 0.152.
 */
package adams.core.discovery;

import adams.core.Utils;
import adams.core.discovery.AbstractGeneticDiscoveryHandler;
import adams.core.discovery.GeneticHelper;
import adams.core.discovery.NumericValueType;
import adams.core.discovery.PropertyPath;
import adams.data.statistics.StatUtils;

public abstract class AbstractGeneticIntegerDiscoveryHandler
extends AbstractGeneticDiscoveryHandler {
    private static final long serialVersionUID = -5442076178374142588L;
    protected NumericValueType m_Type;
    protected int m_Minimum;
    protected int m_Maximum;
    protected int[] m_List;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)this.getDefaultType());
        this.m_OptionManager.add("minimum", "minimum", (Object)this.getDefaultMinimum());
        this.m_OptionManager.add("maximum", "maximum", (Object)this.getDefaultMaximum());
        this.m_OptionManager.add("list", "list", (Object)this.getDefaultList());
    }

    protected NumericValueType getDefaultType() {
        return NumericValueType.RANGE;
    }

    public void setType(NumericValueType value) {
        this.m_Type = value;
        this.reset();
    }

    public NumericValueType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of value to use.";
    }

    protected abstract int getDefaultMinimum();

    public void setMinimum(int value) {
        if (this.getOptionManager().isValid("minimum", (Number)value)) {
            this.m_Minimum = value;
            this.reset();
        }
    }

    public int getMinimum() {
        return this.m_Minimum;
    }

    public String minimumTipText() {
        return "The minimum to use.";
    }

    protected abstract int getDefaultMaximum();

    public void setMaximum(int value) {
        if (this.getOptionManager().isValid("maximum", (Number)value)) {
            this.m_Maximum = value;
            this.reset();
        }
    }

    public int getMaximum() {
        return this.m_Maximum;
    }

    public String maximumTipText() {
        return "The maximum to use.";
    }

    protected abstract String getDefaultList();

    public void setList(String value) {
        String[] parts = value.replaceAll("  ", " ").split(" ");
        int[] list = new int[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            try {
                list[i] = Integer.parseInt(parts[i]);
                continue;
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to parse '" + parts[i] + "' from list: " + value);
                return;
            }
        }
        this.m_List = list;
        this.reset();
    }

    public String getList() {
        return Utils.flatten((Object[])StatUtils.toNumberArray((int[])this.m_List), (String)" ");
    }

    public String listTipText() {
        return "The list to values to use.";
    }

    protected int calcNumBits() {
        int range = this.getMaximum() - this.getMinimum();
        return (int)(Math.floor(Utils.log2((int)range)) + 1.0);
    }

    @Override
    public int getNumBits() {
        return this.calcNumBits();
    }

    protected abstract int getValue(PropertyPath.PropertyContainer var1);

    @Override
    protected String doPack(PropertyPath.PropertyContainer cont) {
        int value = this.getValue(cont);
        switch (this.m_Type) {
            case RANGE: {
                return GeneticHelper.intToBits(value, this.getMinimum(), this.getMaximum(), this.calcNumBits());
            }
            case LIST: {
                int index = 0;
                for (int i = 0; i < this.m_List.length; ++i) {
                    if (this.m_List[i] != value) continue;
                    index = i;
                    break;
                }
                return GeneticHelper.intToBits(index, 0, this.m_List.length, this.calcNumBits());
            }
        }
        throw new IllegalStateException("Unhandled numeric value type: " + (Object)((Object)this.m_Type));
    }

    protected abstract void setValue(PropertyPath.PropertyContainer var1, int var2);

    @Override
    protected void doUnpack(PropertyPath.PropertyContainer cont, String bits) {
        switch (this.m_Type) {
            case RANGE: {
                this.setValue(cont, GeneticHelper.bitsToInt(bits, this.getMinimum(), this.getMaximum()));
                break;
            }
            case LIST: {
                int index = GeneticHelper.bitsToInt(bits, 0, this.m_List.length);
                index = Math.max(0, index);
                index = Math.min(this.m_List.length - 1, index);
                this.setValue(cont, this.m_List[index]);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled numeric value type: " + (Object)((Object)this.m_Type));
            }
        }
    }
}

