/*
 * Decompiled with CFR 0.152.
 */
package adams.core.discovery;

public class GeneticHelper {
    public static int bitsToInt(String bits, int min, int max) {
        double j = 0.0;
        for (int i = 0; i < bits.length(); ++i) {
            if (bits.charAt(i) != '1') continue;
            j += Math.pow(2.0, bits.length() - i - 1);
        }
        return Math.min((int)(j += (double)min), max);
    }

    public static String intToBits(int in, int min, int max, int numBits) {
        in -= min;
        in = Math.min(in, max - min);
        String bits = Integer.toBinaryString(in);
        while (bits.length() < numBits) {
            bits = "0" + bits;
        }
        return bits;
    }

    public static int[] bitsToIntArray(String bits, int min, int max, int numBits, int size) {
        int[] ret = new int[size];
        for (int k = 0; k < size; ++k) {
            int start = numBits * k;
            double j = 0.0;
            for (int i = start; i < start + numBits; ++i) {
                if (bits.charAt(i) != '1') continue;
                j += Math.pow(2.0, start + numBits - i - 1);
            }
            ret[k] = Math.min((int)(j += (double)min), max);
        }
        return ret;
    }

    public static String intArrayToBits(int[] ina, int min, int max, int numBits) {
        StringBuilder buff = new StringBuilder();
        for (int i = 0; i < ina.length; ++i) {
            int in = ina[i];
            in -= min;
            in = Math.min(in, max - min);
            String bits = Integer.toBinaryString(in);
            while (bits.length() < numBits) {
                bits = "0" + bits;
            }
            buff.append(bits);
        }
        return buff.toString();
    }

    public static double bitsToDouble(String bits, double min, double max, int splits) {
        double j = 0.0;
        for (int i = 0; i < bits.length(); ++i) {
            if (bits.charAt(i) != '1') continue;
            j += Math.pow(2.0, bits.length() - i - 1);
        }
        j = Math.min(j, (double)splits);
        return min + j * ((max - min) / (double)(splits - 1));
    }

    public static String doubleToBits(double in, double min, double max, int numBits, int splits) {
        double sdist = (max - min) / ((double)splits - 1.0);
        double dist = in - min;
        double rat = dist / sdist;
        int split = (int)Math.round(rat);
        String bits = Integer.toBinaryString(split);
        while (bits.length() < numBits) {
            bits = "0" + bits;
        }
        return bits;
    }
}

