/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.io.PlaceholderFile;
import adams.data.conversion.AbstractMatchWekaInstanceAgainstHeader;
import java.util.logging.Level;
import weka.core.Instances;
import weka.core.converters.ConverterUtils;

public class MatchWekaInstanceAgainstFileHeader
extends AbstractMatchWekaInstanceAgainstHeader {
    private static final long serialVersionUID = -5909149413572601612L;
    protected PlaceholderFile m_Header;

    public String globalInfo() {
        return "Matches an Instance against a dataset header loaded from a file, i.e., it automatically converts STRING attributes into NOMINAL ones and vice versa.\nThe file can be any format that WEKA recognizes.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("header", "header", (Object)new PlaceholderFile("."));
    }

    public void setHeader(PlaceholderFile value) {
        this.m_Header = value;
        this.reset();
    }

    public PlaceholderFile getHeader() {
        return this.m_Header;
    }

    public String headerTipText() {
        return "The file to load the header from.";
    }

    @Override
    protected Instances getDatasetHeader() {
        Instances result;
        try {
            result = ConverterUtils.DataSource.read((String)this.m_Header.getAbsolutePath());
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to load header from: " + this.m_Header, e);
            throw new IllegalStateException(e);
        }
        return result;
    }
}

