/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.core.AutomatableInteractiveActor;
import adams.flow.core.InteractiveActor;
import adams.flow.source.AbstractArrayProvider;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import weka.gui.AdamsHelper;
import weka.gui.ConverterFileChooser;

public class WekaSelectDataset
extends AbstractArrayProvider
implements InteractiveActor,
AutomatableInteractiveActor {
    private static final long serialVersionUID = 8200691218381875131L;
    protected String m_FileChooserTitle;
    protected PlaceholderDirectory m_InitialDirectory;
    protected PlaceholderFile[] m_InitialFiles;
    protected boolean m_StopFlowIfCanceled;
    protected String m_CustomStopMessage;
    protected boolean m_NonInteractive;

    public String globalInfo() {
        return "Pops up a file chooser dialog, prompting the user to select one or more datasets. The filenames of the datasets then get forwarded as strings.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("stop-if-canceled", "stopFlowIfCanceled", (Object)false);
        this.m_OptionManager.add("custom-stop-message", "customStopMessage", (Object)"");
        this.m_OptionManager.add("file-chooser-title", "fileChooserTitle", (Object)"");
        this.m_OptionManager.add("initial-dir", "initialDirectory", (Object)new PlaceholderDirectory("."));
        this.m_OptionManager.add("initial-file", "initialFiles", (Object)new PlaceholderFile[0]);
        this.m_OptionManager.add("non-interactive", "nonInteractive", (Object)false);
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"initialDirectory", (Object)this.m_InitialDirectory, (String)"directory: ");
        ArrayList options = new ArrayList();
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"outputArray", (boolean)this.m_OutputArray, (String)"array"));
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"stopFlowIfCanceled", (boolean)this.m_StopFlowIfCanceled, (String)"stops flow if canceled"));
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"nonInteractive", (boolean)this.m_NonInteractive, (String)"non-interactive"));
        result = result + QuickInfoHelper.flatten(options);
        return result;
    }

    public String outputArrayTipText() {
        return "Whether to output the files as array or one-by-one.";
    }

    public void setFileChooserTitle(String value) {
        this.m_FileChooserTitle = value;
        this.reset();
    }

    public String getFileChooserTitle() {
        return this.m_FileChooserTitle;
    }

    public String fileChooserTitleTipText() {
        return "The title for the file chooser dialog.";
    }

    public void setInitialDirectory(PlaceholderDirectory value) {
        this.m_InitialDirectory = value;
        this.reset();
    }

    public PlaceholderDirectory getInitialDirectory() {
        return this.m_InitialDirectory;
    }

    public String initialDirectoryTipText() {
        return "The initial directory for the file chooser.";
    }

    public void setInitialFiles(PlaceholderFile[] value) {
        this.m_InitialFiles = value;
        this.reset();
    }

    public PlaceholderFile[] getInitialFiles() {
        return this.m_InitialFiles;
    }

    public String initialFilesTipText() {
        return "The initial files for the file chooser.";
    }

    public void setStopFlowIfCanceled(boolean value) {
        this.m_StopFlowIfCanceled = value;
        this.reset();
    }

    public boolean getStopFlowIfCanceled() {
        return this.m_StopFlowIfCanceled;
    }

    public String stopFlowIfCanceledTipText() {
        return "If enabled, the flow gets stopped in case the user cancels the dialog.";
    }

    public void setCustomStopMessage(String value) {
        this.m_CustomStopMessage = value;
        this.reset();
    }

    public String getCustomStopMessage() {
        return this.m_CustomStopMessage;
    }

    public String customStopMessageTipText() {
        return "The custom stop message to use in case a user cancelation stops the flow (default is the full name of the actor)";
    }

    public void setNonInteractive(boolean value) {
        this.m_NonInteractive = value;
        this.reset();
    }

    public boolean isNonInteractive() {
        return this.m_NonInteractive;
    }

    public String nonInteractiveTipText() {
        return "If enabled, the initial value is forwarded without user interaction.";
    }

    protected Class getItemClass() {
        return String.class;
    }

    public boolean doInteract() {
        boolean result = false;
        this.m_Queue.clear();
        if (this.m_NonInteractive) {
            for (PlaceholderFile file : this.m_InitialFiles) {
                this.m_Queue.add(file.getAbsolutePath());
            }
            return true;
        }
        ConverterFileChooser fileChooser = new ConverterFileChooser();
        AdamsHelper.updateFileChooserAccessory((JFileChooser)fileChooser);
        if (this.m_FileChooserTitle.length() > 0) {
            fileChooser.setDialogTitle(this.m_FileChooserTitle);
        }
        if (this.m_InitialFiles.length > 0) {
            fileChooser.setCurrentDirectory(new File(this.m_InitialFiles[0].getParentFile().getAbsolutePath()));
        } else {
            fileChooser.setCurrentDirectory(new File(this.m_InitialDirectory.getAbsolutePath()));
        }
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(true);
        File[] files = new File[this.m_InitialFiles.length];
        for (int i = 0; i < this.m_InitialFiles.length; ++i) {
            files[i] = new File(this.m_InitialFiles[i].getAbsolutePath());
        }
        fileChooser.setSelectedFiles(files);
        int retVal = fileChooser.showOpenDialog(this.getParentComponent());
        if (retVal == 0) {
            result = true;
            for (File file : files = fileChooser.getSelectedFiles()) {
                this.m_Queue.add(file.getAbsolutePath());
            }
        }
        return result;
    }

    protected String doExecute() {
        if (!this.isHeadless() && !this.doInteract() && this.m_StopFlowIfCanceled) {
            if (this.m_CustomStopMessage == null || this.m_CustomStopMessage.trim().length() == 0) {
                this.stopExecution("Flow canceled: " + this.getFullName());
            } else {
                this.stopExecution(this.m_CustomStopMessage);
            }
        }
        return this.m_StopMessage;
    }
}

