/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Randomizable;
import adams.core.ThreadLimiter;
import adams.core.management.ProcessUtils;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.flow.container.WekaEvaluationContainer;
import adams.flow.container.WekaTrainTestSetContainer;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.standalone.JobRunnerSetup;
import adams.flow.transformer.AbstractCallableWekaClassifierEvaluator;
import adams.multiprocess.Job;
import adams.multiprocess.JobList;
import adams.multiprocess.JobRunner;
import adams.multiprocess.LocalJobRunner;
import adams.multiprocess.WekaCrossValidationJob;
import java.util.Random;
import weka.classifiers.AggregateableEvaluation;
import weka.classifiers.Classifier;
import weka.classifiers.CrossValidationFoldGenerator;
import weka.classifiers.Evaluation;
import weka.classifiers.evaluation.output.prediction.Null;
import weka.core.Instances;

public class WekaCrossValidationEvaluator
extends AbstractCallableWekaClassifierEvaluator
implements Randomizable,
ProvenanceSupporter,
ThreadLimiter {
    private static final long serialVersionUID = -3019442578354930841L;
    protected int m_Folds;
    protected long m_Seed;
    protected int m_NumThreads;
    protected int m_ActualNumThreads;
    protected transient JobRunnerSetup m_JobRunnerSetup;
    protected transient JobRunner m_JobRunner;

    public String globalInfo() {
        return "Cross-validates a classifier on an incoming dataset. The classifier setup being used in the evaluation is a callable 'Classifier' actor.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("seed", "seed", (Object)1L);
        this.m_OptionManager.add("folds", "folds", (Object)10, (Number)-1, null);
        this.m_OptionManager.add("num-threads", "numThreads", (Object)1, (Number)-1, null);
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"folds", (Object)this.m_Folds, (String)", folds: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"seed", (Object)this.m_Seed, (String)", seed: ");
        String variable = QuickInfoHelper.getVariable((OptionHandler)this, (String)"numThreads");
        if (variable != null) {
            result = result + ", threads: " + variable;
        } else if (this.m_NumThreads == 0 || this.m_NumThreads == 1) {
            result = result + ", sequential";
        } else {
            result = result + ", parallel/threads: ";
            result = this.m_NumThreads == -1 ? result + "#cores" : result + this.m_NumThreads;
        }
        return result;
    }

    @Override
    public String classifierTipText() {
        return "The callable classifier actor to cross-validate on the input data.";
    }

    @Override
    public String outputTipText() {
        return "The class for generating prediction output; if 'Null' is used, then an Evaluation object is forwarded instead of a String; not used when using parallel execution.";
    }

    public void setFolds(int value) {
        if (value == -1 || value >= 2) {
            this.m_Folds = value;
            this.reset();
        } else {
            this.getLogger().severe("Number of folds must be >=2 or -1 for LOOCV, provided: " + value);
        }
    }

    public int getFolds() {
        return this.m_Folds;
    }

    public String foldsTipText() {
        return "The number of folds to use in the cross-validation; use -1 for leave-one-out cross-validation (LOOCV).";
    }

    public void setSeed(long value) {
        this.m_Seed = value;
        this.reset();
    }

    public long getSeed() {
        return this.m_Seed;
    }

    public String seedTipText() {
        return "The seed value for the cross-validation (used for randomization).";
    }

    public void setNumThreads(int value) {
        this.m_NumThreads = value;
        this.reset();
    }

    public int getNumThreads() {
        return this.m_NumThreads;
    }

    public String numThreadsTipText() {
        return "The number of threads to use for cross-validation -1 = number of CPUs/cores; 0 or 1 = sequential execution.";
    }

    public Class[] accepts() {
        return new Class[]{Instances.class};
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_JobRunnerSetup = (JobRunnerSetup)ActorUtils.findClosestType((AbstractActor)this, JobRunnerSetup.class);
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        try {
            Classifier cls = this.getClassifierInstance();
            if (cls == null) {
                throw new IllegalStateException("Classifier '" + this.getClassifier() + "' not found!");
            }
            if (this.isLoggingEnabled()) {
                this.getLogger().info(OptionUtils.getCommandLine((Object)cls));
            }
            Instances data = (Instances)this.m_InputToken.getPayload();
            int folds = this.m_Folds;
            if (folds == -1) {
                folds = data.numInstances();
            }
            this.m_ActualNumThreads = this.m_NumThreads == -1 ? ProcessUtils.getAvailableProcessors() : (this.m_NumThreads > 1 ? Math.min(this.m_NumThreads, folds) : 0);
            if (this.m_ActualNumThreads == 0) {
                this.initOutputBuffer();
                this.m_Output.setHeader(data);
                Evaluation eval = new Evaluation(data);
                eval.setDiscardPredictions(this.m_DiscardPredictions);
                eval.crossValidateModel(cls, data, folds, new Random(this.m_Seed), new Object[]{this.m_Output});
                if (!this.isStopped()) {
                    this.m_OutputToken = this.m_Output instanceof Null ? new Token((Object)new WekaEvaluationContainer(eval)) : (this.m_AlwaysUseContainer ? new Token((Object)new WekaEvaluationContainer(eval, null, this.m_Output.getBuffer().toString())) : new Token((Object)this.m_Output.getBuffer().toString()));
                }
            } else {
                WekaCrossValidationJob job;
                CrossValidationFoldGenerator generator = new CrossValidationFoldGenerator(data, folds, this.m_Seed, true);
                this.m_JobRunner = this.m_JobRunnerSetup == null ? new LocalJobRunner() : this.m_JobRunnerSetup.newInstance();
                if (this.m_JobRunner instanceof ThreadLimiter) {
                    ((ThreadLimiter)this.m_JobRunner).setNumThreads(this.m_NumThreads);
                }
                JobList list = new JobList();
                while (generator.hasNext()) {
                    WekaTrainTestSetContainer cont = generator.next();
                    job = new WekaCrossValidationJob(this.getClassifierInstance(), (Instances)cont.getValue("Train"), (Instances)cont.getValue("Test"), (Integer)cont.getValue("FoldNumber"), this.m_DiscardPredictions);
                    list.add((Job)job);
                }
                this.m_JobRunner.add(list);
                this.m_JobRunner.start();
                this.m_JobRunner.stop();
                AggregateableEvaluation evalAgg = new AggregateableEvaluation(data);
                if (!this.isStopped()) {
                    for (int i = 0; i < this.m_JobRunner.getJobs().size(); ++i) {
                        job = (WekaCrossValidationJob)((Object)this.m_JobRunner.getJobs().get(i));
                        if (job.getEvaluation() == null) {
                            result = "Fold #" + (i + 1) + " failed to evaluate";
                            if (!job.hasExecutionError()) {
                                result = result + "?";
                                break;
                            }
                            result = result + ":\n" + job.getExecutionError();
                            break;
                        }
                        evalAgg.aggregate(job.getEvaluation());
                        job.cleanUp();
                    }
                }
                list.cleanUp();
                this.m_JobRunner.cleanUp();
                this.m_JobRunner = null;
                if (!this.isStopped()) {
                    this.m_OutputToken = new Token((Object)new WekaEvaluationContainer((Evaluation)evalAgg));
                }
            }
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("Failed to cross-validate classifier: ", e);
        }
        if (this.m_OutputToken != null) {
            this.updateProvenance((ProvenanceContainer)this.m_OutputToken);
        }
        return result;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            if (this.m_InputToken.hasProvenance()) {
                cont.setProvenance(this.m_InputToken.getProvenance().getClone());
            }
            cont.addProvenance(new ProvenanceInformation(ActorType.EVALUATOR, this.m_InputToken.getPayload().getClass(), (AbstractActor)this, this.m_OutputToken.getPayload().getClass()));
        }
    }

    public void stopExecution() {
        if (this.m_JobRunner != null) {
            this.m_JobRunner.terminate();
        }
        super.stopExecution();
    }
}

