/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Pausable;
import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.logging.LoggingObject;
import adams.core.option.OptionHandler;
import adams.event.FitnessChangeEvent;
import adams.event.FitnessChangeListener;
import adams.event.FlowPauseStateEvent;
import adams.event.FlowPauseStateListener;
import adams.event.VariableChangeListener;
import adams.flow.container.WekaGeneticAlgorithmContainer;
import adams.flow.core.AbstractActor;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.CallableActorUser;
import adams.flow.core.ErrorHandler;
import adams.flow.core.InputConsumer;
import adams.flow.core.PauseStateHandler;
import adams.flow.core.PauseStateManager;
import adams.flow.core.Token;
import adams.flow.standalone.JobRunnerSetup;
import adams.flow.transformer.AbstractTransformer;
import adams.genetic.AbstractClassifierBasedGeneticAlgorithm;
import adams.genetic.AbstractGeneticAlgorithm;
import adams.genetic.DarkLord;
import java.util.HashSet;
import java.util.Hashtable;
import weka.classifiers.Classifier;
import weka.core.Instances;

public class WekaGeneticAlgorithm
extends AbstractTransformer
implements FitnessChangeListener,
CallableActorUser,
FlowPauseStateListener,
Pausable {
    private static final long serialVersionUID = 5071747277597147724L;
    public static final String BACKUP_CALLABLEACTOR = "callable actor";
    public static final String BACKUP_CONFIGURED = "configured";
    protected AbstractClassifierBasedGeneticAlgorithm m_Algorithm;
    protected transient AbstractClassifierBasedGeneticAlgorithm m_ActualAlgorithm;
    protected CallableActorReference m_CallableName;
    protected AbstractActor m_CallableActor;
    protected boolean m_Configured;
    protected CallableActorHelper m_Helper;
    protected boolean m_Optional;
    protected PauseStateManager m_PauseStateManager;
    protected transient JobRunnerSetup m_JobRunnerSetup;

    public String globalInfo() {
        return "Applies the genetic algorithm to the incoming dataset.\nForwards the best setup after the algorithm finishes.\nA callable sink can be specified for receiving intermediate performance results.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("algorithm", "algorithm", (Object)new DarkLord());
        this.m_OptionManager.add("callable", "callableName", (Object)new CallableActorReference("unknown"));
        this.m_OptionManager.add("optional", "optional", (Object)false);
    }

    protected void reset() {
        super.reset();
        this.m_CallableActor = null;
        this.m_Configured = false;
    }

    protected void initialize() {
        super.initialize();
        this.m_Helper = new CallableActorHelper();
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"algorithm", (Object)((Object)this.m_Algorithm), (String)"algorithm: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"callableName", (Object)this.m_CallableName, (String)", callable: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"optional", (boolean)this.m_Optional, (String)"optional", (String)", ");
        return result;
    }

    public void setAlgorithm(AbstractClassifierBasedGeneticAlgorithm value) {
        this.m_Algorithm = value;
        this.reset();
    }

    public AbstractClassifierBasedGeneticAlgorithm getAlgorithm() {
        return this.m_Algorithm;
    }

    public String algorithmTipText() {
        return "The genetic algorithm to apply to the dataset.";
    }

    public void setCallableName(CallableActorReference value) {
        this.m_CallableName = value;
        this.reset();
    }

    public CallableActorReference getCallableName() {
        return this.m_CallableName;
    }

    public String callableNameTipText() {
        return "The name of the callable sink to forward to the " + WekaGeneticAlgorithmContainer.class.getName() + " containers.";
    }

    public void setOptional(boolean value) {
        this.m_Optional = value;
        this.reset();
    }

    public boolean getOptional() {
        return this.m_Optional;
    }

    public String optionalTipText() {
        return "If enabled, then the callable sink is optional, ie no error is raised if not found, merely ignored.";
    }

    public Class[] accepts() {
        return new Class[]{Instances.class};
    }

    public Class[] generates() {
        return new Class[]{WekaGeneticAlgorithmContainer.class};
    }

    protected AbstractActor findCallableActor() {
        AbstractActor result = this.m_Helper.findCallableActorRecursive((AbstractActor)this, this.getCallableName());
        if (result != null && !ActorUtils.isSink((Actor)result)) {
            this.getLogger().severe("Callable actor '" + result.getFullName() + "' is not a sink" + (this.m_CallableActor == null ? "!" : this.m_CallableActor.getClass().getName()));
            result = null;
        }
        return result;
    }

    public boolean hasCallableActor() {
        return this.m_CallableActor != null;
    }

    public AbstractActor getCallableActor() {
        return this.m_CallableActor;
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_CALLABLEACTOR);
        this.pruneBackup(BACKUP_CONFIGURED);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_CallableActor != null) {
            result.put(BACKUP_CALLABLEACTOR, this.m_CallableActor);
        }
        result.put(BACKUP_CONFIGURED, this.m_Configured);
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        super.restoreState(state);
        if (state.containsKey(BACKUP_CALLABLEACTOR)) {
            this.m_CallableActor = (AbstractActor)state.get(BACKUP_CALLABLEACTOR);
            state.remove(BACKUP_CALLABLEACTOR);
        }
        if (state.containsKey(BACKUP_CONFIGURED)) {
            this.m_Configured = (Boolean)state.get(BACKUP_CONFIGURED);
            state.remove(BACKUP_CONFIGURED);
        }
    }

    protected String setUpCallableActor() {
        String result = null;
        this.m_CallableActor = this.findCallableActor();
        this.m_Configured = true;
        if (this.m_CallableActor == null) {
            if (!this.m_Optional) {
                result = "Couldn't find callable actor '" + this.getCallableName() + "'!";
            } else {
                this.getLogger().info("Callable actor '" + this.getCallableName() + "' not found, ignoring.");
            }
        } else {
            HashSet variables = this.findVariables(this.m_CallableActor);
            this.m_DetectedVariables.addAll(variables);
            if (this.m_DetectedVariables.size() > 0) {
                this.getVariables().addVariableChangeListener((VariableChangeListener)this);
            }
            if (this.getErrorHandler() != this) {
                ActorUtils.updateErrorHandler((Actor)this.m_CallableActor, (ErrorHandler)this.getErrorHandler(), (boolean)this.isLoggingEnabled());
            }
        }
        return result;
    }

    public String setUp() {
        String variable;
        String result = super.setUp();
        if (result == null && (variable = this.getOptionManager().getVariableForProperty("callableName")) == null) {
            result = this.setUpCallableActor();
        }
        if (this.getRoot() instanceof PauseStateHandler) {
            this.m_PauseStateManager = ((PauseStateHandler)this.getRoot()).getPauseStateManager();
            if (this.m_PauseStateManager != null) {
                this.m_PauseStateManager.addListener((FlowPauseStateListener)this);
            }
        } else {
            this.m_PauseStateManager = null;
        }
        if (result == null) {
            this.m_JobRunnerSetup = (JobRunnerSetup)ActorUtils.findClosestType((AbstractActor)this, JobRunnerSetup.class);
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        Instances data = (Instances)this.m_InputToken.getPayload();
        WekaGeneticAlgorithmContainer cont = null;
        this.m_ActualAlgorithm = (AbstractClassifierBasedGeneticAlgorithm)this.m_Algorithm.shallowCopy(true);
        this.m_ActualAlgorithm.addFitnessChangeListener(this);
        this.m_ActualAlgorithm.setJobRunnerSetup(this.m_JobRunnerSetup);
        this.m_ActualAlgorithm.setFlowContext((Actor)this);
        try {
            this.m_ActualAlgorithm.setInstances(data);
            this.m_ActualAlgorithm.run();
            if (this.m_ActualAlgorithm.isStopped()) {
                result = "Genetic algorithm stopped!";
            } else {
                cont = new WekaGeneticAlgorithmContainer((Classifier)this.m_ActualAlgorithm.getCurrentSetup(), this.m_ActualAlgorithm.getMeasure(), this.m_ActualAlgorithm.getCurrentFitness(), AbstractGeneticAlgorithm.GeneticAlgorithmJob.weightsToString((int[])this.m_ActualAlgorithm.getCurrentWeights()), this.m_ActualAlgorithm.getCurrentWeights());
            }
            this.m_ActualAlgorithm.removeFitnessChangeListener(this);
            this.m_ActualAlgorithm = null;
        }
        catch (Exception e) {
            result = this.handleException("Failed to run genetic algorithm!", e);
        }
        if (cont != null) {
            this.m_OutputToken = new Token(cont);
        }
        return result;
    }

    public void stopExecution() {
        if (this.m_ActualAlgorithm != null) {
            this.m_ActualAlgorithm.stopExecution();
            while (this.m_ActualAlgorithm.isRunning()) {
                Utils.wait((LoggingObject)this, (int)1000, (int)100);
            }
            this.m_ActualAlgorithm.removeFitnessChangeListener(this);
        }
        if (this.m_PauseStateManager != null && this.m_PauseStateManager.isPaused()) {
            this.m_PauseStateManager.resume((AbstractActor)this);
        }
        super.stopExecution();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fitnessChanged(FitnessChangeEvent e) {
        String result = null;
        if (!this.m_Configured) {
            result = this.setUpCallableActor();
        }
        if (result == null && this.m_CallableActor != null) {
            WekaGeneticAlgorithmContainer cont = new WekaGeneticAlgorithmContainer((Classifier)e.getSetup(), ((AbstractClassifierBasedGeneticAlgorithm)e.getGeneticAlgorithm()).getMeasure(), e.getFitness(), AbstractGeneticAlgorithm.GeneticAlgorithmJob.weightsToString((int[])e.getWeights()), e.getWeights());
            if (!this.m_CallableActor.getSkip() && !this.m_CallableActor.isStopped()) {
                AbstractActor abstractActor = this.m_CallableActor;
                synchronized (abstractActor) {
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("Executing callable sink - start: " + this.m_CallableActor);
                    }
                    ((InputConsumer)this.m_CallableActor).input(new Token((Object)cont));
                    result = this.m_CallableActor.execute();
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("Executing callable sink - end: " + result);
                    }
                }
            }
        }
    }

    public void pauseExecution() {
        if (this.m_PauseStateManager != null) {
            this.m_PauseStateManager.pause((AbstractActor)this);
        }
    }

    public boolean isPaused() {
        if (this.m_PauseStateManager != null) {
            return this.m_PauseStateManager.isPaused();
        }
        return false;
    }

    public void resumeExecution() {
        if (this.m_PauseStateManager != null) {
            this.m_PauseStateManager.resume((AbstractActor)this);
        }
    }

    public void flowPauseStateChanged(FlowPauseStateEvent e) {
        if (this.m_ActualAlgorithm != null) {
            switch (e.getType()) {
                case PAUSED: {
                    this.m_ActualAlgorithm.pauseExecution();
                    break;
                }
                case RESUMED: {
                    this.m_ActualAlgorithm.resumeExecution();
                }
            }
        }
    }
}

