/*
 * Decompiled with CFR 0.152.
 */
package adams.genetic;

import adams.core.discovery.AbstractDiscoveryHandler;
import adams.core.discovery.AbstractGeneticDiscoveryHandler;
import adams.core.discovery.DefaultPropertyDiscovery;
import adams.core.discovery.PropertyPath;
import adams.core.option.OptionUtils;
import adams.genetic.AbstractClassifierBasedGeneticAlgorithm;
import adams.genetic.OutputType;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import weka.classifiers.Classifier;
import weka.core.Instances;

public class Hermione
extends AbstractClassifierBasedGeneticAlgorithm {
    private static final long serialVersionUID = -4982024446995877986L;
    protected AbstractGeneticDiscoveryHandler[] m_Handlers;
    protected AbstractGeneticDiscoveryHandler[] m_ActualHandlers;
    protected List<Integer> m_numbits = null;
    protected List<Integer> m_start = null;
    protected transient Boolean m_HandlersInitialized;

    public String globalInfo() {
        return "Hermione.";
    }

    protected void initialize() {
        super.initialize();
        this.m_ActualHandlers = new AbstractGeneticDiscoveryHandler[0];
        this.m_HandlersInitialized = null;
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("handler", "handlers", (Object)new AbstractGeneticDiscoveryHandler[0]);
    }

    public void setHandlers(AbstractGeneticDiscoveryHandler[] value) {
        this.m_Handlers = value;
        this.reset();
    }

    public AbstractGeneticDiscoveryHandler[] getHandlers() {
        return this.m_Handlers;
    }

    public String handlersTipText() {
        return "The discovery handlers to use.";
    }

    @Override
    protected OutputType getDefaultOutputType() {
        return OutputType.SETUP;
    }

    @Override
    protected HermioneJob newJob(int num, int[] w, Instances data) {
        return new HermioneJob(this, num, w, data);
    }

    protected void initializeHandlersIfRequired() {
        if (this.m_HandlersInitialized == null || !this.m_HandlersInitialized.booleanValue()) {
            this.initializeHandlers();
        }
    }

    protected void initializeHandlers() {
        this.setupParamsAndClassifier(this.m_Handlers, this.m_Classifier);
        this.m_HandlersInitialized = true;
        this.init(20, this.getNumBits() * this.m_BitsPerGene);
    }

    @Override
    protected void preRun() {
        super.preRun();
        this.initializeHandlers();
    }

    protected void setupParamsAndClassifier(AbstractGeneticDiscoveryHandler[] p, Classifier c) {
        this.m_ActualHandlers = new AbstractGeneticDiscoveryHandler[p.length];
        for (int i = 0; i < p.length; ++i) {
            this.m_ActualHandlers[i] = (AbstractGeneticDiscoveryHandler)p[i].shallowCopy();
        }
        DefaultPropertyDiscovery d = new DefaultPropertyDiscovery();
        d.setLoggingLevel(this.getLoggingLevel());
        d.discover((AbstractDiscoveryHandler[])this.m_ActualHandlers, (Object)c);
        if (this.isLoggingEnabled()) {
            for (int i = 0; i < this.m_ActualHandlers.length; ++i) {
                this.getLogger().info(i + 1 + ". " + OptionUtils.getCommandLine((Object)((Object)this.m_ActualHandlers[i])));
                for (PropertyPath.PropertyContainer cont : this.m_ActualHandlers[i].getContainers()) {
                    this.getLogger().info("   " + cont.getPath());
                }
            }
        }
    }

    public String intAtoStringA(int[] ia) {
        String ret = new String();
        for (int i = 0; i < ia.length; ++i) {
            ret = ret + "" + ia[i];
        }
        return ret;
    }

    public int[] getBitsForPosition(int[] w, List<Integer> spoints, List<Integer> numbits, int pos) {
        this.initializeHandlersIfRequired();
        int[] ret = new int[numbits.get(pos).intValue()];
        int c = 0;
        for (int i = spoints.get(pos).intValue(); i < spoints.get(pos) + numbits.get(pos); ++i) {
            ret[c++] = w[i];
        }
        return ret;
    }

    public List<Integer> getNumBitsForAll() {
        this.initializeHandlersIfRequired();
        ArrayList<Integer> al = new ArrayList<Integer>();
        for (AbstractGeneticDiscoveryHandler ag : this.m_ActualHandlers) {
            List lpc = ag.getContainers();
            for (PropertyPath.PropertyContainer pc : lpc) {
                al.add(ag.getNumBits());
            }
        }
        return al;
    }

    public List<Integer> getStartPoints() {
        this.initializeHandlersIfRequired();
        ArrayList<Integer> al = new ArrayList<Integer>();
        int count = 0;
        for (AbstractGeneticDiscoveryHandler ag : this.m_ActualHandlers) {
            List lpc = ag.getContainers();
            for (PropertyPath.PropertyContainer pc : lpc) {
                al.add(count);
                count += ag.getNumBits();
            }
        }
        return al;
    }

    public int getNumBits() {
        this.initializeHandlersIfRequired();
        int count = 0;
        for (AbstractGeneticDiscoveryHandler ag : this.m_ActualHandlers) {
            List lpc = ag.getContainers();
            for (PropertyPath.PropertyContainer pc : lpc) {
                count += ag.getNumBits();
            }
        }
        return count;
    }

    public Classifier generateClassifier(int[] weights) {
        this.initializeHandlersIfRequired();
        if (this.m_numbits == null) {
            this.m_numbits = this.getNumBitsForAll();
        }
        if (this.m_start == null) {
            this.m_start = this.getStartPoints();
        }
        if (this.isLoggingEnabled()) {
            StringBuilder w = new StringBuilder();
            for (int i = 0; i < weights.length; ++i) {
                w.append(weights[i]);
            }
            this.getLogger().info("Weights: " + w);
        }
        DefaultPropertyDiscovery d = new DefaultPropertyDiscovery();
        AbstractDiscoveryHandler[] cp = new AbstractGeneticDiscoveryHandler[this.m_ActualHandlers.length];
        for (int i = 0; i < cp.length; ++i) {
            cp[i] = (AbstractGeneticDiscoveryHandler)this.m_ActualHandlers[i].shallowCopy();
        }
        Classifier c = null;
        try {
            c = (Classifier)OptionUtils.shallowCopy((Object)this.getClassifier());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        d.discover(cp, (Object)c);
        int pos = 0;
        for (AbstractDiscoveryHandler ag : cp) {
            List lpc = ag.getContainers();
            for (PropertyPath.PropertyContainer pc : lpc) {
                String sa = this.intAtoStringA(this.getBitsForPosition(weights, this.m_start, this.m_numbits, pos));
                ag.unpack(pc, sa);
                ++pos;
            }
        }
        return c;
    }

    public static class HermioneJob
    extends AbstractClassifierBasedGeneticAlgorithm.ClassifierBasedGeneticAlgorithmJob<Hermione> {
        private static final long serialVersionUID = 8259167463381721274L;

        public HermioneJob(Hermione g, int num, int[] w, Instances data) {
            super(g, num, w, data);
        }

        public void calcNewFitness() {
            try {
                this.getLogger().fine("calc for:" + this.weightsToString());
                Double cc = ((Hermione)this.getOwner()).getResult(this.weightsToString());
                if (cc != null) {
                    this.getLogger().info("Already present: " + Double.toString(cc));
                    this.m_Fitness = cc;
                    return;
                }
                Instances newInstances = new Instances(this.getInstances());
                Classifier newClassifier = ((Hermione)this.getOwner()).generateClassifier(this.m_Weights);
                this.m_Fitness = this.evaluateClassifier(newClassifier, newInstances);
                if (((Hermione)this.getOwner()).setNewFitness(this.m_Fitness, newClassifier, this.m_Weights)) {
                    this.generateOutput(this.m_Fitness, newInstances, newClassifier, this.m_Weights);
                    ((Hermione)this.getOwner()).notifyFitnessChangeListeners(this.getMeasure().adjust(this.m_Fitness), newClassifier, this.m_Weights);
                }
                ((Hermione)this.getOwner()).addResult(this.weightsToString(), this.m_Fitness);
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Error: ", e);
                this.m_Fitness = null;
            }
        }
    }
}

