/*
 * Decompiled with CFR 0.152.
 */
package adams.genetic;

import weka.classifiers.Evaluation;
import weka.core.Instances;
import weka.core.UnassignedClassException;

public enum Measure {
    CC(false, false, true),
    RMSE(true, true, true),
    RRSE(true, true, true),
    MAE(true, true, true),
    RAE(true, true, true),
    ACC(false, true, false);

    private boolean m_Negative;
    private boolean m_Nominal;
    private boolean m_Numeric;

    private Measure(boolean negative, boolean nominal, boolean numeric) {
        this.m_Negative = negative;
        this.m_Nominal = nominal;
        this.m_Numeric = numeric;
    }

    public double extract(Evaluation evaluation, boolean adjust) throws Exception {
        double result;
        if (this == ACC) {
            result = evaluation.pctCorrect();
        } else if (this == CC) {
            result = evaluation.correlationCoefficient();
        } else if (this == MAE) {
            result = evaluation.meanAbsoluteError();
        } else if (this == RAE) {
            result = evaluation.relativeAbsoluteError();
        } else if (this == RMSE) {
            result = evaluation.rootMeanSquaredError();
        } else if (this == RRSE) {
            result = evaluation.rootRelativeSquaredError();
        } else {
            throw new IllegalStateException("Unhandled measure '" + (Object)((Object)this) + "'!");
        }
        if (adjust) {
            result = this.adjust(result);
        }
        return result;
    }

    public double adjust(double measure) {
        if (this.m_Negative) {
            return -measure;
        }
        return measure;
    }

    public boolean isValid(Instances data) {
        if (data.classIndex() == -1) {
            throw new UnassignedClassException("No class attribute set!");
        }
        if (data.classAttribute().isNominal()) {
            return this.m_Nominal;
        }
        if (data.classAttribute().isNumeric()) {
            return this.m_Numeric;
        }
        throw new IllegalStateException("Class attribute '" + data.classAttribute().type() + "' not handled!");
    }
}

