/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import weka.classifiers.AbstainingClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.SingleClassifierEnhancer;
import weka.classifiers.ThreadSafeClassifier;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;

public class ThreadSafeClassifierWrapper
extends SingleClassifierEnhancer
implements AbstainingClassifier,
ThreadSafeClassifier {
    private static final long serialVersionUID = 5699323936859571421L;
    protected boolean m_CanAbstain = false;

    public String globalInfo() {
        return "Wraps an abstaining classifier and allows turning on/of abstaining.";
    }

    public synchronized void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        this.m_Classifier.buildClassifier(data);
        this.m_CanAbstain = this.m_Classifier instanceof AbstainingClassifier && ((AbstainingClassifier)this.m_Classifier).canAbstain();
    }

    public synchronized double classifyInstance(Instance instance) throws Exception {
        return super.classifyInstance(instance);
    }

    public synchronized double[] distributionForInstance(Instance instance) throws Exception {
        return this.m_Classifier.distributionForInstance(instance);
    }

    @Override
    public boolean canAbstain() {
        return this.m_CanAbstain;
    }

    @Override
    public synchronized double getAbstentionClassification(Instance inst) throws Exception {
        if (this.canAbstain()) {
            return ((AbstainingClassifier)this.m_Classifier).getAbstentionClassification(inst);
        }
        return Utils.missingValue();
    }

    @Override
    public synchronized double[] getAbstentionDistribution(Instance inst) throws Exception {
        if (this.canAbstain()) {
            return ((AbstainingClassifier)this.m_Classifier).getAbstentionDistribution(inst);
        }
        return null;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + "\n");
        result.append(this.getClass().getSimpleName().replaceAll(".", "=") + "\n");
        result.append("\n");
        result.append(this.m_Classifier.toString());
        return result.toString();
    }

    public static void main(String[] args) {
        ThreadSafeClassifierWrapper.runClassifier((Classifier)new ThreadSafeClassifierWrapper(), (String[])args);
    }
}

