/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.SimpleBatchFilter;
import weka.filters.UnsupervisedFilter;

public class RemoveWithZeroes
extends SimpleBatchFilter
implements UnsupervisedFilter {
    private static final long serialVersionUID = -6784901276150528252L;
    protected double m_NumZeroes = 1.0;
    protected int m_NumNumericAttributes;
    protected int m_MinZeroes;

    public String globalInfo() {
        return "Removes all instances that contain at least the specified number (or percentage) of zeroes in numeric attributes.";
    }

    public Enumeration listOptions() {
        Vector<Object> result = new Vector<Object>();
        result.addElement(new Option("\tThe number of zeroes that an instance must at least contain in\n\torder to be removed. If the number is between 0 and 1, it is \n\tinterpreted as percentage.\n", "num-zeroes", 1, "-num-zeroes <number of zeroes or percentage>"));
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.add(enm.nextElement());
        }
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((String)"num-zeroes", (String[])options);
        if (tmpStr.length() == 0) {
            this.setNumZeroes(1.0);
        } else {
            this.setNumZeroes(Double.parseDouble(tmpStr));
        }
        super.setOptions(options);
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-num-zeroes");
        result.add("" + this.getNumZeroes());
        result.addAll(Arrays.asList(super.getOptions()));
        return result.toArray(new String[result.size()]);
    }

    public void setNumZeroes(double value) {
        if (this.m_NumZeroes > 0.0 && this.m_NumZeroes < 1.0) {
            this.m_NumZeroes = value;
        } else if (this.m_NumZeroes >= 1.0 && Math.floor(this.m_NumZeroes) == Math.ceil(this.m_NumZeroes)) {
            this.m_NumZeroes = value;
        } else {
            System.err.println("Number of zeroes must be >0 and values >1 must be integers, provided: " + value);
        }
    }

    public double getNumZeroes() {
        return this.m_NumZeroes;
    }

    public String numZeroesTipText() {
        return "The number of zeroes that a row must have in order to be removed; 0-1 is interpreted as percentage.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.enableAll();
        result.enable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(0);
        return result;
    }

    protected void reset() {
        super.reset();
        this.m_NumNumericAttributes = 0;
        this.m_MinZeroes = Integer.MAX_VALUE;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        this.m_NumNumericAttributes = 0;
        for (int i = 0; i < inputFormat.numAttributes(); ++i) {
            if (!inputFormat.attribute(i).isNumeric()) continue;
            ++this.m_NumNumericAttributes;
        }
        this.m_MinZeroes = this.m_NumZeroes < 1.0 ? (int)Math.round((double)this.m_NumNumericAttributes * this.m_NumZeroes) : (int)this.m_NumZeroes;
        return new Instances(inputFormat, 0);
    }

    protected Instances process(Instances instances) throws Exception {
        if (this.m_FirstBatchDone) {
            return new Instances(instances);
        }
        Instances result = new Instances(instances, instances.numInstances());
        for (int i = 0; i < instances.numInstances(); ++i) {
            Instance inst = instances.instance(i);
            int numZeroes = 0;
            for (int n = 0; n < inst.numAttributes(); ++n) {
                if (!inst.attribute(n).isNumeric() || inst.value(n) != 0.0) continue;
                ++numZeroes;
            }
            if (numZeroes < this.m_MinZeroes) {
                result.add((Instance)inst.copy());
                continue;
            }
            if (!this.m_Debug) continue;
            System.out.println("Instance #" + (i + 1) + " contains more than " + this.m_NumZeroes + (this.m_NumZeroes < 1.0 ? " (" + this.m_MinZeroes + ")" : "") + " zeroes.");
        }
        result.compactify();
        if (this.m_Debug) {
            System.out.println("Reduction: " + instances.numInstances() + " -> " + result.numInstances());
        }
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 10824 $");
    }

    public static void main(String[] args) {
        RemoveWithZeroes.runFilter((Filter)new RemoveWithZeroes(), (String[])args);
    }
}

