/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.experiment.ext;

import adams.core.option.OptionUtils;
import adams.gui.core.BaseListWithButtons;
import adams.gui.goe.WekaGenericObjectEditorPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import weka.classifiers.Classifier;
import weka.classifiers.rules.ZeroR;
import weka.gui.experiment.ext.AbstractSetupOptionPanel;

public class ClassifierPanel
extends AbstractSetupOptionPanel {
    private static final long serialVersionUID = -832431512063524253L;
    protected WekaGenericObjectEditorPanel m_PanelGOE;
    protected BaseListWithButtons m_List;
    protected JButton m_ButtonAdd;
    protected JButton m_ButtonEdit;
    protected JButton m_ButtonRemove;
    protected JButton m_ButtonRemoveAll;
    protected JButton m_ButtonUp;
    protected JButton m_ButtonDown;
    protected DefaultListModel<String> m_Model;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Model = new DefaultListModel();
    }

    protected void initGUI() {
        super.initGUI();
        this.m_PanelGOE = new WekaGenericObjectEditorPanel(Classifier.class, new ZeroR(), true);
        this.add((Component)((Object)this.m_PanelGOE), "North");
        this.m_List = new BaseListWithButtons(this.m_Model);
        this.add((Component)this.m_List, "Center");
        this.m_ButtonAdd = new JButton("Add");
        this.m_ButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClassifierPanel.this.m_Model.addElement(OptionUtils.getCommandLine((Object)ClassifierPanel.this.m_PanelGOE.getCurrent()));
                ClassifierPanel.this.modified();
                ClassifierPanel.this.update();
            }
        });
        this.m_ButtonEdit = new JButton("Edit");
        this.m_ButtonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ClassifierPanel.this.m_PanelGOE.setCurrent((Classifier)OptionUtils.forAnyCommandLine(Classifier.class, (String)((String)ClassifierPanel.this.m_List.getSelectedValue())));
                    ClassifierPanel.this.m_PanelGOE.choose();
                    ClassifierPanel.this.m_Model.setElementAt(OptionUtils.getCommandLine((Object)ClassifierPanel.this.m_PanelGOE.getCurrent()), ClassifierPanel.this.m_List.getSelectedIndex());
                    ClassifierPanel.this.modified();
                }
                catch (Exception ex) {
                    System.err.println("Failed to instantiate classifier: " + ClassifierPanel.this.m_List.getSelectedValue());
                    ex.printStackTrace();
                }
                ClassifierPanel.this.update();
            }
        });
        this.m_ButtonRemove = new JButton("Remove");
        this.m_ButtonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] indices = ClassifierPanel.this.m_List.getSelectedIndices();
                Arrays.sort(indices);
                for (int i = indices.length - 1; i >= 0; --i) {
                    ClassifierPanel.this.m_Model.remove(indices[i]);
                }
                ClassifierPanel.this.modified();
                ClassifierPanel.this.update();
            }
        });
        this.m_ButtonRemoveAll = new JButton("Remove all");
        this.m_ButtonRemoveAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClassifierPanel.this.m_Model.clear();
                ClassifierPanel.this.modified();
                ClassifierPanel.this.update();
            }
        });
        this.m_ButtonUp = new JButton("Up");
        this.m_ButtonUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClassifierPanel.this.m_List.moveUp();
                ClassifierPanel.this.modified();
                ClassifierPanel.this.update();
            }
        });
        this.m_ButtonDown = new JButton("Down");
        this.m_ButtonDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClassifierPanel.this.m_List.moveDown();
                ClassifierPanel.this.modified();
                ClassifierPanel.this.update();
            }
        });
        this.m_List.addToButtonsPanel((Component)this.m_ButtonAdd);
        this.m_List.addToButtonsPanel((Component)this.m_ButtonEdit);
        this.m_List.addToButtonsPanel((Component)this.m_ButtonRemove);
        this.m_List.addToButtonsPanel((Component)this.m_ButtonRemoveAll);
        this.m_List.addToButtonsPanel((Component)new JLabel(""));
        this.m_List.addToButtonsPanel((Component)this.m_ButtonUp);
        this.m_List.addToButtonsPanel((Component)this.m_ButtonDown);
        this.m_List.setDoubleClickButton(this.m_ButtonEdit);
        this.m_List.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ClassifierPanel.this.update();
            }
        });
    }

    @Override
    protected void finishInit() {
        super.finishInit();
        this.update();
    }

    @Override
    protected void update() {
        super.update();
        this.m_ButtonEdit.setEnabled(this.m_List.getSelectedIndices().length == 1);
        this.m_ButtonRemove.setEnabled(this.m_List.getSelectedIndices().length > 0);
        this.m_ButtonRemoveAll.setEnabled(this.m_Model.getSize() > 0);
        this.m_ButtonUp.setEnabled(this.m_List.canMoveUp());
        this.m_ButtonDown.setEnabled(this.m_List.canMoveDown());
    }

    public void setClassifiers(Classifier[] value) {
        this.m_IgnoreChanges = true;
        this.m_Model.clear();
        for (Classifier c : value) {
            this.m_Model.addElement(OptionUtils.getCommandLine((Object)c));
        }
        this.m_IgnoreChanges = false;
    }

    public Classifier[] getClassifiers() {
        Classifier[] result = new Classifier[this.m_Model.getSize()];
        for (int i = 0; i < this.m_Model.getSize(); ++i) {
            try {
                result[i] = (Classifier)OptionUtils.forAnyCommandLine(Classifier.class, (String)this.m_Model.getElementAt(i));
                continue;
            }
            catch (Exception e) {
                System.err.println("Failed to instantiate classifier: " + this.m_Model.getElementAt(i));
                e.printStackTrace();
                result[i] = new ZeroR();
            }
        }
        return result;
    }
}

