/*
 * Decompiled with CFR 0.152.
 */
package adams.core.management;

import adams.core.management.AbstractClassPathAugmenter;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.packageManagement.Package;
import weka.core.Environment;
import weka.core.WekaPackageManager;

public class WekaPackagesClassPathAugmenter
extends AbstractClassPathAugmenter {
    private static final long serialVersionUID = 5783582495315373807L;
    protected List<String> m_Augmentations;

    public String globalInfo() {
        return "Returns the classpath augmentations for all the installed WEKA packages.";
    }

    protected void loadPackageDirectory(File directory) {
        File[] contents = directory.listFiles();
        for (int i = 0; i < contents.length; ++i) {
            if (contents[i].isFile() && contents[i].getPath().endsWith(".jar")) {
                this.m_Augmentations.add(contents[i].getAbsolutePath());
                continue;
            }
            if (!contents[i].isDirectory() || !contents[i].getName().equalsIgnoreCase("lib")) continue;
            this.loadPackageDirectory(contents[i]);
        }
    }

    public synchronized String[] getClassPathAugmentation() {
        this.m_Augmentations = new ArrayList<String>();
        Environment env = Environment.getSystemWide();
        String loadPackages = env.getVariableValue("weka.core.loadPackages");
        if (loadPackages != null && loadPackages.equalsIgnoreCase("false")) {
            return new String[0];
        }
        WekaPackageManager.loadPackages((boolean)false);
        File[] contents = WekaPackageManager.PACKAGES_DIR.listFiles();
        for (int i = 0; i < contents.length; ++i) {
            if (!contents[i].isDirectory()) continue;
            try {
                boolean load;
                Package toLoad = WekaPackageManager.getInstalledPackageInfo((String)contents[i].getName());
                if (toLoad == null || !(load = WekaPackageManager.loadCheck((Package)toLoad, (File)contents[i], (PrintStream[])new PrintStream[]{System.err}))) continue;
                this.loadPackageDirectory(contents[i]);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println("[WEKA] Problem loading package " + contents[i].getName() + " skipping...");
            }
        }
        return this.m_Augmentations.toArray(new String[this.m_Augmentations.size()]);
    }
}

