/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.SerializationHelper;
import adams.flow.container.WekaModelContainer;
import adams.flow.sink.AbstractFileWriter;
import java.util.Arrays;
import java.util.Vector;

public abstract class AbstractWekaModelWriter
extends AbstractFileWriter {
    private static final long serialVersionUID = -259222073894194923L;

    public String outputFileTipText() {
        return "The filename to save the model (and optional header) in.";
    }

    public Class[] accepts() {
        Vector<Class> result = new Vector<Class>();
        result.add(WekaModelContainer.class);
        result.addAll(Arrays.asList(this.getAdditionalAcceptedClasses()));
        return result.toArray(new Class[result.size()]);
    }

    protected Class[] getAdditionalAcceptedClasses() {
        return new Class[0];
    }

    protected String doExecute() {
        String result = null;
        try {
            if (this.m_InputToken.getPayload() instanceof WekaModelContainer) {
                WekaModelContainer cont = (WekaModelContainer)((Object)this.m_InputToken.getPayload());
                if (cont.hasValue("Header")) {
                    SerializationHelper.writeAll((String)this.m_OutputFile.getAbsolutePath(), (Object[])new Object[]{cont.getValue("Model"), cont.getValue("Header")});
                } else {
                    SerializationHelper.write((String)this.m_OutputFile.getAbsolutePath(), (Object)cont.getValue("Model"));
                }
            } else {
                SerializationHelper.write((String)this.m_OutputFile.getAbsolutePath(), (Object)this.m_InputToken.getPayload());
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to serialize model data to '" + this.m_OutputFile + "':", e);
        }
        return result;
    }
}

