/*
 * Decompiled with CFR 0.152.
 */
package adams.genetic;

import adams.core.Properties;
import adams.core.ThreadLimiter;
import adams.core.io.PlaceholderDirectory;
import adams.core.option.OptionUtils;
import adams.data.weka.WekaAttributeIndex;
import adams.event.FitnessChangeNotifier;
import adams.flow.core.Actor;
import adams.flow.standalone.JobRunnerSetup;
import adams.genetic.AbstractGeneticAlgorithm;
import adams.genetic.Measure;
import adams.genetic.OutputPrefixType;
import adams.genetic.OutputType;
import adams.multiprocess.Job;
import adams.multiprocess.JobList;
import adams.multiprocess.LocalJobRunner;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.rules.ZeroR;
import weka.core.Instances;

public abstract class AbstractClassifierBasedGeneticAlgorithm
extends AbstractGeneticAlgorithm
implements FitnessChangeNotifier {
    private static final long serialVersionUID = 1615849384907266578L;
    public static final String PROPS_RELATION = "relation";
    public static final String PROPS_FILTER = "filter";
    public static final String PROPS_MASK = "mask";
    protected WekaAttributeIndex m_ClassIndex;
    protected Instances m_Instances;
    protected int m_BitsPerGene;
    protected Classifier m_Classifier;
    protected int m_Folds;
    protected int m_CrossValidationSeed;
    protected Measure m_Measure;
    protected PlaceholderDirectory m_OutputDirectory;
    protected OutputType m_OutputType;
    protected OutputPrefixType m_OutputPrefixType;
    protected String m_SuppliedPrefix;
    public Hashtable<String, Double> m_StoredResults = new Hashtable();
    protected transient JobRunnerSetup m_JobRunnerSetup;
    protected Actor m_FlowContext;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("bits-per-gene", "bitsPerGene", (Object)1, (Number)1, null);
        this.m_OptionManager.add("class", "classIndex", (Object)new WekaAttributeIndex("last"));
        this.m_OptionManager.add("folds", "folds", (Object)10, (Number)2, null);
        this.m_OptionManager.add("cv-seed", "crossValidationSeed", (Object)55);
        this.m_OptionManager.add("classifier", "classifier", (Object)this.getDefaultClassifier());
        this.m_OptionManager.add("measure", "measure", (Object)Measure.RMSE);
        this.m_OptionManager.add("output-dir", "outputDirectory", (Object)new PlaceholderDirectory("."));
        this.m_OptionManager.add("output-type", "outputType", (Object)this.getDefaultOutputType());
        this.m_OptionManager.add("output-prefix-type", "outputPrefixType", (Object)OutputPrefixType.NONE);
        this.m_OptionManager.add("supplied-prefix", "suppliedPrefix", (Object)"");
    }

    public void setClassIndex(WekaAttributeIndex value) {
        this.m_ClassIndex = value;
        this.reset();
    }

    public WekaAttributeIndex getClassIndex() {
        return this.m_ClassIndex;
    }

    public String classIndexTipText() {
        return "The class index of the dataset, in case no class attribute is set.";
    }

    public void setInstances(Instances value) {
        this.m_Instances = value;
    }

    public Instances getInstances() {
        return this.m_Instances;
    }

    public void setFolds(int value) {
        this.m_Folds = value;
        this.reset();
    }

    public int getFolds() {
        return this.m_Folds;
    }

    public String foldsTipText() {
        return "The number of folds to use in cross-validation.";
    }

    public void setCrossValidationSeed(int value) {
        this.m_CrossValidationSeed = value;
        this.reset();
    }

    public int getCrossValidationSeed() {
        return this.m_CrossValidationSeed;
    }

    public String crossValidationSeedTipText() {
        return "The seed value for cross-validation.";
    }

    protected Classifier getDefaultClassifier() {
        return new ZeroR();
    }

    public void setClassifier(Classifier value) {
        this.m_Classifier = value;
        this.reset();
    }

    public Classifier getClassifier() {
        return this.m_Classifier;
    }

    public String classifierTipText() {
        return "The classifier to use.";
    }

    public void setBitsPerGene(int value) {
        this.m_BitsPerGene = value;
        this.reset();
    }

    public int getBitsPerGene() {
        return this.m_BitsPerGene;
    }

    public String bitsPerGeneTipText() {
        return "The number of bits per gene to use.";
    }

    public void setMeasure(Measure value) {
        this.m_Measure = value;
        this.reset();
    }

    public Measure getMeasure() {
        return this.m_Measure;
    }

    public String measureTipText() {
        return "The measure used for evaluating the fitness.";
    }

    public void setOutputDirectory(PlaceholderDirectory value) {
        this.m_OutputDirectory = value;
        this.reset();
    }

    public PlaceholderDirectory getOutputDirectory() {
        return this.m_OutputDirectory;
    }

    public String outputDirectoryTipText() {
        return "The directory for storing the generated ARFF files.";
    }

    protected abstract OutputType getDefaultOutputType();

    public void setOutputType(OutputType value) {
        this.m_OutputType = value;
        this.reset();
    }

    public OutputType getOutputType() {
        return this.m_OutputType;
    }

    public String outputTypeTipText() {
        return "The type of output to generate.";
    }

    public void setOutputPrefixType(OutputPrefixType value) {
        this.m_OutputPrefixType = value;
        this.reset();
    }

    public OutputPrefixType getOutputPrefixType() {
        return this.m_OutputPrefixType;
    }

    public String outputPrefixTypeTipText() {
        return "The type of prefix to use for the output.";
    }

    public void setSuppliedPrefix(String value) {
        this.m_SuppliedPrefix = value;
        this.reset();
    }

    public String getSuppliedPrefix() {
        return this.m_SuppliedPrefix;
    }

    public String suppliedPrefixTipText() {
        return "The prefix to use in case of " + (Object)((Object)OutputPrefixType.SUPPLIED) + ".";
    }

    public void setJobRunnerSetup(JobRunnerSetup value) {
        this.m_JobRunnerSetup = value;
    }

    public JobRunnerSetup getJobRunnerSetup() {
        return this.m_JobRunnerSetup;
    }

    public void setFlowContext(Actor value) {
        this.m_FlowContext = value;
    }

    public Actor getFlowContext() {
        return this.m_FlowContext;
    }

    public double getCurrentFitness() {
        return this.m_Measure.adjust(this.m_BestFitness);
    }

    protected Properties storeSetup(Instances data, AbstractGeneticAlgorithm.GeneticAlgorithmJob job) {
        Properties result = new Properties();
        result.setProperty(PROPS_RELATION, data.relationName());
        result.setProperty(PROPS_FILTER, "");
        return result;
    }

    public Instances updateHeader(Instances data, AbstractGeneticAlgorithm.GeneticAlgorithmJob job) {
        Properties props = this.storeSetup(data, job);
        data.setRelationName(props.toString());
        return data;
    }

    protected synchronized void addResult(String key, Double val) {
        this.m_StoredResults.put(key, val);
    }

    protected synchronized Double getResult(String key) {
        return this.m_StoredResults.get(key);
    }

    protected synchronized void clearResults() {
        this.m_StoredResults.clear();
    }

    public Vector<int[]> getInitialSetups() {
        return new Vector<int[]>();
    }

    protected abstract ClassifierBasedGeneticAlgorithmJob newJob(int var1, int[] var2, Instances var3);

    public void calcFitness() {
        int i;
        Object runner = this.m_JobRunnerSetup == null ? new LocalJobRunner() : this.m_JobRunnerSetup.newInstance();
        if (runner instanceof ThreadLimiter) {
            ((ThreadLimiter)runner).setNumThreads(this.getNumThreads());
        }
        runner.setFlowContext(this.getFlowContext());
        JobList jobs = new JobList();
        for (i = 0; i < this.getNumChrom(); ++i) {
            int[] weights = new int[this.getNumGenes()];
            for (int j = 0; j < this.getNumGenes(); ++j) {
                int weight = 0;
                for (int k = 0; k < this.getBitsPerGene(); ++k) {
                    weight <<= 1;
                    if (!this.getGene(i, j * this.getBitsPerGene() + k)) continue;
                    ++weight;
                }
                weights[j] = weight;
            }
            jobs.add((Job)this.newJob(i, weights, this.m_Instances));
        }
        runner.add(jobs);
        runner.start();
        runner.stop();
        for (i = 0; i < runner.getJobs().size(); ++i) {
            ClassifierBasedGeneticAlgorithmJob job = (ClassifierBasedGeneticAlgorithmJob)((Object)runner.getJobs().get(i));
            this.m_Fitness[job.getNumChrom()] = job.getFitness() == null ? Double.NEGATIVE_INFINITY : job.getFitness();
            job.cleanUp();
        }
        runner.cleanUp();
    }

    protected void preRun() {
        super.preRun();
        this.m_ClassIndex.setData(this.m_Instances);
        if (this.m_Instances.classIndex() == -1) {
            this.m_Instances.setClassIndex(this.m_ClassIndex.getIntIndex());
        }
        if (this.m_BestRange.getRange().length() != 0) {
            this.m_BestRange.setMax(this.m_Instances.numAttributes());
        }
        if (!this.m_Measure.isValid(this.m_Instances)) {
            throw new IllegalArgumentException("Measure '" + (Object)((Object)this.m_Measure) + "' cannot process class of type '" + this.m_Instances.classAttribute().type() + "'!");
        }
        this.clearResults();
    }

    public String toString() {
        return super.toString() + "\n" + this.getCurrentFitness() + " (measure: " + (Object)((Object)this.getMeasure()) + ")";
    }

    public static abstract class ClassifierBasedGeneticAlgorithmJob<T extends AbstractClassifierBasedGeneticAlgorithm>
    extends AbstractGeneticAlgorithm.GeneticAlgorithmJob<T> {
        private static final long serialVersionUID = 8259167463381721274L;
        protected Measure m_Measure;
        protected Instances m_Data;
        protected int m_Seed;
        protected int m_Folds;

        public ClassifierBasedGeneticAlgorithmJob(T g, int num, int[] w, Instances data) {
            super(g, num, w);
            this.m_Measure = ((AbstractClassifierBasedGeneticAlgorithm)((Object)g)).getMeasure();
            this.m_Data = data;
            this.m_Seed = ((AbstractClassifierBasedGeneticAlgorithm)((Object)g)).getCrossValidationSeed();
            this.m_Folds = ((AbstractClassifierBasedGeneticAlgorithm)((Object)g)).getFolds();
        }

        protected Instances getInstances() {
            return this.m_Data;
        }

        public Measure getMeasure() {
            return this.m_Measure;
        }

        public int getSeed() {
            return this.m_Seed;
        }

        public int getFolds() {
            return this.m_Folds;
        }

        protected String preProcessCheck() {
            String result = super.preProcessCheck();
            if (result == null && this.getInstances() == null) {
                result = "No instances provided!";
            }
            return result;
        }

        protected double evaluateClassifier(Classifier cls, Instances data) throws Exception {
            Evaluation evaluation = new Evaluation(data);
            evaluation.crossValidateModel(cls, data, this.getFolds(), new Random(this.getSeed()), new Object[0]);
            return this.getMeasure().extract(evaluation, true);
        }

        protected File createFileName(double fitness, Instances data, String ext) {
            String filename = ((AbstractClassifierBasedGeneticAlgorithm)this.getOwner()).getOutputDirectory().getAbsolutePath() + File.separator;
            switch (((AbstractClassifierBasedGeneticAlgorithm)this.getOwner()).getOutputPrefixType()) {
                case NONE: {
                    break;
                }
                case RELATION: {
                    filename = filename + data.relationName() + "-";
                    break;
                }
                case SUPPLIED: {
                    filename = filename + ((AbstractClassifierBasedGeneticAlgorithm)this.getOwner()).getSuppliedPrefix() + "-";
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled output prefix type: " + (Object)((Object)((AbstractClassifierBasedGeneticAlgorithm)this.getOwner()).getOutputPrefixType()));
                }
            }
            filename = filename + Double.toString(this.getMeasure().adjust(fitness)) + "." + ext;
            return new File(filename);
        }

        protected void outputDataset(double fitness, Instances data) throws Exception {
            File file = this.createFileName(fitness, data, "arff");
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            Instances header = new Instances(data, 0);
            header = ((AbstractClassifierBasedGeneticAlgorithm)this.getOwner()).updateHeader(header, this);
            writer.write(header.toString());
            writer.write("\n");
            for (int i = 0; i < data.numInstances(); ++i) {
                writer.write(data.instance(i).toString());
                writer.write("\n");
            }
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }

        protected Properties assembleSetup(double fitness, Classifier cls, int[] weights) {
            Properties result = new Properties();
            result.setProperty("Commandline", OptionUtils.getCommandLine((Object)this.getOwner()));
            result.setProperty("Measure", "" + (Object)((Object)this.getMeasure()));
            result.setDouble("Fitness", Double.valueOf(fitness));
            result.setProperty("Setup", OptionUtils.getCommandLine((Object)cls));
            result.setProperty("Weights", ClassifierBasedGeneticAlgorithmJob.weightsToString((int[])weights));
            return result;
        }

        protected void outputSetup(double fitness, Instances data, Classifier cls, int[] weights) throws Exception {
            File file = this.createFileName(fitness, data, "props");
            Properties props = this.assembleSetup(fitness, cls, weights);
            if (!props.save(file.getAbsolutePath())) {
                this.getLogger().warning("Failed to write setup to '" + file + "'!");
            }
        }

        protected void generateOutput(double fitness, Instances data, Classifier cls, int[] weights) throws Exception {
            switch (((AbstractClassifierBasedGeneticAlgorithm)this.getOwner()).getOutputType()) {
                case NONE: {
                    break;
                }
                case SETUP: {
                    this.outputSetup(fitness, data, cls, weights);
                    break;
                }
                case DATA: {
                    this.outputDataset(fitness, data);
                    break;
                }
                case ALL: {
                    this.outputDataset(fitness, data);
                    this.outputSetup(fitness, data, cls, weights);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled output type: " + (Object)((Object)((AbstractClassifierBasedGeneticAlgorithm)this.getOwner()).getOutputType()));
                }
            }
        }
    }
}

