/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.gui.chooser.AbstractConfigurableExtensionFileFilterFileChooser;
import adams.gui.chooser.ExtensionFileFilterWithClass;
import adams.gui.chooser.FileTypeDeterminingFileChooser;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import weka.core.converters.AArffLoader;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.ArffSaver;
import weka.gui.GenericObjectEditor;

public class WekaFileChooser
extends AbstractConfigurableExtensionFileFilterFileChooser<AbstractFileLoader, AbstractFileSaver>
implements FileTypeDeterminingFileChooser<AbstractFileLoader, AbstractFileSaver> {
    private static final long serialVersionUID = -6341967475735162796L;
    protected static List<ExtensionFileFilterWithClass> m_ReaderFileFilters;
    protected static List<ExtensionFileFilterWithClass> m_WriterFileFilters;

    public WekaFileChooser() {
    }

    public WekaFileChooser(File currentDirectory) {
        super(currentDirectory);
    }

    public WekaFileChooser(String currentDirectory) {
        super(currentDirectory);
    }

    protected boolean getFiltersInitialized() {
        return m_ReaderFileFilters != null;
    }

    protected void doInitializeFilters() {
        try {
            WekaFileChooser.initFilters(true, GenericObjectEditor.getClassnames((String)AbstractFileLoader.class.getName()));
            WekaFileChooser.initFilters(false, GenericObjectEditor.getClassnames((String)AbstractFileSaver.class.getName()));
        }
        catch (Exception e) {
            WekaFileChooser.handleException((String)"Failed to initialize Weka loader/saver filters!", (Throwable)e);
        }
    }

    protected static void initFilters(boolean reader, Vector<String> classnames) {
        if (reader) {
            m_ReaderFileFilters = new ArrayList<ExtensionFileFilterWithClass>();
        } else {
            m_WriterFileFilters = new ArrayList<ExtensionFileFilterWithClass>();
        }
        for (int i = 0; i < classnames.size(); ++i) {
            ExtensionFileFilterWithClass filter;
            String[] ext;
            String desc;
            Object converter;
            Class<?> cls;
            String classname = classnames.get(i);
            try {
                cls = Class.forName(classname);
                converter = cls.newInstance();
                if (reader) {
                    desc = ((AbstractFileLoader)converter).getFileDescription();
                    ext = ((AbstractFileLoader)converter).getFileExtensions();
                } else {
                    desc = ((AbstractFileSaver)converter).getFileDescription();
                    ext = ((AbstractFileSaver)converter).getFileExtensions();
                }
            }
            catch (Exception e) {
                WekaFileChooser.handleException((String)("Failed to set up: " + classname), (Throwable)e);
                cls = null;
                converter = null;
                ext = new String[]{};
                desc = "";
            }
            if (converter == null) continue;
            if (reader) {
                filter = new ExtensionFileFilterWithClass(classname, desc, ext);
                m_ReaderFileFilters.add(filter);
                continue;
            }
            filter = new ExtensionFileFilterWithClass(classname, desc, ext);
            m_WriterFileFilters.add(filter);
        }
        if (reader) {
            Collections.sort(m_ReaderFileFilters);
        } else {
            Collections.sort(m_WriterFileFilters);
        }
    }

    protected List<ExtensionFileFilterWithClass> getOpenFileFilters() {
        return m_ReaderFileFilters;
    }

    protected List<ExtensionFileFilterWithClass> getSaveFileFilters() {
        return m_WriterFileFilters;
    }

    protected Class getReaderClass() {
        return AbstractFileLoader.class;
    }

    protected Class getWriterClass() {
        return AbstractFileSaver.class;
    }

    protected AbstractFileLoader getDefaultReader() {
        return new AArffLoader();
    }

    protected AbstractFileSaver getDefaultWriter() {
        return new ArffSaver();
    }

    public AbstractFileLoader getReaderForFile(File file) {
        AbstractFileLoader result = null;
        for (ExtensionFileFilterWithClass filter : m_ReaderFileFilters) {
            if (!filter.accept(file)) continue;
            try {
                result = (AbstractFileLoader)Class.forName(filter.getClassname()).newInstance();
            }
            catch (Exception e) {
                WekaFileChooser.handleException((String)("Failed to instantiate reader: " + filter.getClassname()), (Throwable)e);
            }
        }
        return result;
    }

    public AbstractFileSaver getWriterForFile(File file) {
        AbstractFileSaver result = null;
        for (ExtensionFileFilterWithClass filter : m_WriterFileFilters) {
            if (!filter.accept(file)) continue;
            try {
                result = (AbstractFileSaver)Class.forName(filter.getClassname()).newInstance();
            }
            catch (Exception e) {
                WekaFileChooser.handleException((String)("Failed to instantiate writer: " + filter.getClassname()), (Throwable)e);
            }
        }
        return result;
    }
}

