/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.option.OptionUtils;
import adams.gui.core.BaseDialog;
import adams.gui.core.BasePopupMenu;
import adams.gui.core.GUIHelper;
import adams.gui.core.TextEditorPanel;
import adams.gui.goe.AbstractGenericObjectEditorHandler;
import adams.gui.goe.GenericArrayEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditor;
import java.lang.reflect.Array;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WekaGenericObjectEditorPopupMenu
extends BasePopupMenu {
    private static final long serialVersionUID = -5216584001020734521L;
    protected HashSet<ChangeListener> m_ChangeListeners = new HashSet();

    public WekaGenericObjectEditorPopupMenu(final PropertyEditor editor, final JComponent comp) {
        JMenuItem item = null;
        boolean canChangeClass = this.getCanChangeClassInDialog(editor);
        if (editor instanceof GenericArrayEditor) {
            canChangeClass = this.getCanChangeClassInDialog(((GenericArrayEditor)editor).getElementEditor());
        }
        item = new JMenuItem("Copy setup", GUIHelper.getEmptyIcon());
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringBuilder content = new StringBuilder();
                Object current = editor.getValue();
                boolean isArray = current.getClass().isArray();
                if (isArray) {
                    for (int i = 0; i < Array.getLength(current); ++i) {
                        if (i > 0) {
                            content.append("\n");
                        }
                        content.append(OptionUtils.getCommandLine((Object)Array.get(current, i)));
                    }
                } else {
                    content.append(OptionUtils.getCommandLine((Object)current));
                }
                if (content.length() > 0) {
                    GUIHelper.copyToClipboard((String)content.toString());
                }
            }
        });
        this.add(item);
        if (canChangeClass) {
            item = new JMenuItem("Paste setup", GUIHelper.getIcon((String)"paste.gif"));
            item.setEnabled(GUIHelper.canPasteStringFromClipboard());
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WekaGenericObjectEditorPopupMenu.this.updateEditor(editor, comp, GUIHelper.pasteSetupFromClipboard());
                }
            });
            this.add(item);
            item = new JMenuItem("Enter setup...", GUIHelper.getIcon((String)"input.png"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    final BaseDialog dlg = GUIHelper.getParentDialog((Container)comp) != null ? new BaseDialog(GUIHelper.getParentDialog((Container)comp), Dialog.ModalityType.DOCUMENT_MODAL) : new BaseDialog(GUIHelper.getParentFrame((Container)comp), true);
                    dlg.setTitle("Enter setup");
                    dlg.getContentPane().setLayout(new BorderLayout());
                    final TextEditorPanel textpanel = new TextEditorPanel();
                    dlg.getContentPane().add((Component)textpanel, "Center");
                    JButton buttonOK = new JButton("OK");
                    buttonOK.setMnemonic('O');
                    buttonOK.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            dlg.setVisible(false);
                            WekaGenericObjectEditorPopupMenu.this.updateEditor(editor, comp, textpanel.getContent());
                        }
                    });
                    JButton buttonCancel = new JButton("Cancel");
                    buttonCancel.setMnemonic('C');
                    buttonCancel.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            dlg.setVisible(false);
                        }
                    });
                    JPanel panel = new JPanel(new FlowLayout(2));
                    panel.add(buttonOK);
                    panel.add(buttonCancel);
                    dlg.getContentPane().add((Component)panel, "South");
                    dlg.pack();
                    dlg.setSize(400, 300);
                    dlg.setLocationRelativeTo((Component)comp);
                    dlg.setVisible(true);
                }
            });
            this.add(item);
        }
    }

    protected boolean updateEditor(PropertyEditor editor, JComponent comp, String str) {
        boolean result = true;
        GenericArrayEditor gae = null;
        String[] parts = new String[]{};
        if (editor instanceof GenericArrayEditor) {
            gae = (GenericArrayEditor)editor;
            gae.removeAllObjects();
            parts = str.split("\n");
        }
        try {
            if (gae != null) {
                for (String part : parts) {
                    gae.addObject(OptionUtils.forString(Object.class, (String)part));
                }
            } else {
                editor.setValue(OptionUtils.forString(Object.class, (String)str));
            }
            editor.setValue(editor.getValue());
            comp.repaint();
            this.notifyChangeListeners();
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
            GUIHelper.showErrorMessage((Component)comp, (String)("Error processing setup from clipboard:\n" + e));
        }
        return result;
    }

    protected boolean getCanChangeClassInDialog(PropertyEditor editor) {
        AbstractGenericObjectEditorHandler handler = AbstractGenericObjectEditorHandler.getHandler((Object)editor);
        return handler.getCanChangeClassInDialog(editor);
    }

    public void addChangeListener(ChangeListener l) {
        this.m_ChangeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.m_ChangeListeners.remove(l);
    }

    protected void notifyChangeListeners() {
        ChangeEvent e = new ChangeEvent((Object)this);
        for (ChangeListener l : this.m_ChangeListeners) {
            l.stateChanged(e);
        }
    }
}

