/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.menu;

import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.gui.application.AbstractApplicationFrame;
import adams.gui.application.ChildFrame;
import adams.gui.application.UserMode;
import adams.gui.core.GUIHelper;
import adams.gui.menu.AbstractParameterHandlingWekaMenuItemDefinition;
import java.awt.Component;
import java.io.File;
import weka.core.Instances;
import weka.gui.ConverterFileChooser;
import weka.gui.visualize.PlotData2D;
import weka.gui.visualize.ThresholdVisualizePanel;

public class CostCurve
extends AbstractParameterHandlingWekaMenuItemDefinition {
    private static final long serialVersionUID = -771667287275117680L;
    protected ConverterFileChooser m_FileChooser;

    public CostCurve() {
        this(null);
    }

    public CostCurve(AbstractApplicationFrame owner) {
        super(owner);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_FileChooser = new ConverterFileChooser(new File(System.getProperty("user.dir")));
    }

    public void launch() {
        Instances result;
        File file;
        if (this.m_Parameters.length == 0) {
            int retVal = this.m_FileChooser.showOpenDialog(null);
            if (retVal != 0) {
                return;
            }
            file = this.m_FileChooser.getSelectedFile();
        } else {
            file = new PlaceholderFile(this.m_Parameters[0]).getAbsoluteFile();
            this.m_FileChooser.setSelectedFile(file);
        }
        try {
            result = this.m_FileChooser.getLoader().getDataSet();
        }
        catch (Exception e) {
            GUIHelper.showErrorMessage((Component)this.getOwner(), (String)("Error loading file '" + file + "':\n" + Utils.throwableToString((Throwable)e)));
            return;
        }
        result.setClassIndex(result.numAttributes() - 1);
        ThresholdVisualizePanel vmc = new ThresholdVisualizePanel();
        PlotData2D plot = new PlotData2D(result);
        plot.setPlotName(result.relationName());
        plot.m_displayAllPoints = true;
        boolean[] connectPoints = new boolean[result.numInstances()];
        for (int cp = 1; cp < connectPoints.length; ++cp) {
            connectPoints[cp] = true;
        }
        try {
            plot.setConnectPoints(connectPoints);
            vmc.addPlot(plot);
        }
        catch (Exception e) {
            GUIHelper.showErrorMessage((Component)this.getOwner(), (String)("Error adding plot:\n" + Utils.throwableToString((Throwable)e)));
            return;
        }
        ChildFrame frame = this.createChildFrame((Component)vmc, 800, 600);
        frame.setTitle(frame.getTitle() + " - " + file);
    }

    public String getTitle() {
        return "WEKA Cost curve";
    }

    public boolean isSingleton() {
        return false;
    }

    public UserMode getUserMode() {
        return UserMode.BASIC;
    }

    @Override
    public String getCategory() {
        return "Visualization";
    }
}

