/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.core.Utils;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseTextArea;
import adams.gui.core.Fonts;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.sendto.SendToActionSupporter;
import adams.gui.sendto.SendToActionUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import weka.core.Instances;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.ConverterUtils;
import weka.gui.ConverterFileChooser;

public class DatasetCompatibilityPanel
extends BasePanel
implements MenuBarProvider,
SendToActionSupporter {
    private static final long serialVersionUID = -5581002075106885237L;
    protected ConverterFileChooser m_FileChooser;
    protected BaseTextArea m_TextArea;
    protected File[] m_CurrentFiles;
    protected AbstractFileLoader m_CurrentLoader;
    protected JMenuBar m_MenuBar;
    protected JMenuItem m_MenuItemReload;

    protected void initialize() {
        super.initialize();
        this.m_FileChooser = new ConverterFileChooser(".");
        this.m_FileChooser.setMultiSelectionEnabled(true);
        this.m_FileChooser.setFileMustExist(true);
        this.m_CurrentFiles = new File[0];
        this.m_CurrentLoader = null;
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_TextArea = new BaseTextArea();
        this.m_TextArea.setEditable(false);
        this.m_TextArea.setFont(Fonts.getMonospacedFont());
        this.add((Component)new BaseScrollPane((Component)this.m_TextArea), "Center");
    }

    public JMenuBar getMenuBar() {
        JMenuBar result;
        if (this.m_MenuBar == null) {
            result = new JMenuBar();
            JMenu menu = new JMenu("File");
            result.add(menu);
            menu.setMnemonic('F');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    DatasetCompatibilityPanel.this.updateMenu();
                }
            });
            JMenuItem menuitem = new JMenuItem("Open...");
            menu.add(menuitem);
            menuitem.setMnemonic('O');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed O"));
            menuitem.setIcon(GUIHelper.getIcon((String)"open.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DatasetCompatibilityPanel.this.open();
                }
            });
            menuitem = new JMenuItem("Reload");
            menu.add(menuitem);
            menuitem.setMnemonic('R');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"F5"));
            menuitem.setIcon(GUIHelper.getIcon((String)"refresh.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DatasetCompatibilityPanel.this.reload();
                }
            });
            this.m_MenuItemReload = menuitem;
            menu.addSeparator();
            if (SendToActionUtils.addSendToSubmenu((SendToActionSupporter)this, (JMenu)menu)) {
                menu.addSeparator();
            }
            menuitem = new JMenuItem("Close");
            menu.add(menuitem);
            menuitem.setMnemonic('C');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed Q"));
            menuitem.setIcon(GUIHelper.getIcon((String)"exit.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DatasetCompatibilityPanel.this.close();
                }
            });
            this.m_MenuBar = result;
            this.updateMenu();
        } else {
            result = this.m_MenuBar;
        }
        return result;
    }

    protected void updateMenu() {
        if (this.m_MenuBar == null) {
            return;
        }
        this.m_MenuItemReload.setEnabled(this.m_CurrentFiles.length > 0 && this.m_CurrentLoader != null);
    }

    public void open() {
        int retVal = this.m_FileChooser.showOpenDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        if (this.m_FileChooser.getSelectedFiles().length < 2) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)"You must choose at least two files!");
            return;
        }
        this.open(this.m_FileChooser.getSelectedFiles(), this.m_FileChooser.getLoader());
    }

    public String open(File[] files) {
        if (files.length < 2) {
            return "You must supply at least two files!";
        }
        AbstractFileLoader loader = ConverterUtils.getLoaderForFile((File)files[0].getAbsoluteFile());
        if (loader == null) {
            return "Failed to determine loader for files!";
        }
        return this.open(files, loader);
    }

    protected String open(File[] files, AbstractFileLoader loader) {
        if (files.length < 2) {
            return "You must supply at least two files!";
        }
        if (loader == null) {
            return "No file loader specified!";
        }
        Instances[] datasets = new Instances[files.length];
        for (int i = 0; i < files.length; ++i) {
            try {
                loader.setFile(files[i].getAbsoluteFile());
                datasets[i] = loader.getStructure();
                loader.reset();
                continue;
            }
            catch (Exception e) {
                return "Failed to load dataset from " + files[i] + ":\n" + Utils.throwableToString((Throwable)e);
            }
        }
        this.compare(files, datasets);
        return null;
    }

    protected void compare(File[] files, Instances[] datasets) {
        this.m_TextArea.setText("");
        for (int i = 0; i < files.length - 1; ++i) {
            for (int n = i + 1; n < files.length; ++n) {
                String msg = datasets[i].equalHeadersMsg(datasets[n]);
                this.m_TextArea.append("--> " + files[i].toString() + "\n" + "and " + files[n].toString() + "\n" + Utils.indent((String)(msg == null ? "match" : msg), (int)4) + "\n");
            }
        }
    }

    public void reload() {
        this.open(this.m_CurrentFiles, this.m_CurrentLoader);
    }

    public void close() {
        this.closeParent();
    }

    public Class[] getSendToClasses() {
        return new Class[]{String.class, JTextComponent.class};
    }

    public boolean hasSendToItem(Class[] cls) {
        return SendToActionUtils.isAvailable((Class[])new Class[]{String.class, JTextComponent.class}, (Class[])cls) && this.m_TextArea.getText().length() > 0;
    }

    public Object getSendToItem(Class[] cls) {
        String result = null;
        if (SendToActionUtils.isAvailable(String.class, (Class[])cls)) {
            result = this.m_TextArea.getText();
            if (result.length() == 0) {
                result = null;
            }
        } else if (SendToActionUtils.isAvailable(JTextComponent.class, (Class[])cls) && this.m_TextArea.getText().length() > 0) {
            result = this.m_TextArea;
        }
        return result;
    }
}

