/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.instance;

import adams.data.instance.Instance;
import adams.gui.event.DataChangeEvent;
import adams.gui.event.DataChangeListener;
import adams.gui.visualization.container.AbstractContainer;
import adams.gui.visualization.container.AbstractContainerManager;
import adams.gui.visualization.container.ColorContainerManager;
import adams.gui.visualization.container.ContainerListManager;
import adams.gui.visualization.container.NamedContainerManager;
import adams.gui.visualization.container.SearchableContainerManager;
import adams.gui.visualization.container.VisibilityContainerManager;
import adams.gui.visualization.core.AbstractColorProvider;
import adams.gui.visualization.core.DefaultColorProvider;
import adams.gui.visualization.instance.InstanceContainer;
import gnu.trove.list.array.TIntArrayList;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class InstanceContainerManager
extends AbstractContainerManager<InstanceContainer>
implements VisibilityContainerManager<InstanceContainer>,
NamedContainerManager,
ColorContainerManager,
SearchableContainerManager<InstanceContainer> {
    private static final long serialVersionUID = -4325235760470150191L;
    protected ContainerListManager<InstanceContainerManager> m_Owner;
    protected AbstractColorProvider m_ColorProvider;
    protected String m_SearchString;
    protected boolean m_SearchRegexp;
    protected TIntArrayList m_FilteredList;

    public InstanceContainerManager(ContainerListManager<InstanceContainerManager> owner) {
        this.m_Owner = owner;
        this.m_ColorProvider = new DefaultColorProvider();
        this.m_FilteredList = null;
        if (owner instanceof DataChangeListener) {
            this.addDataChangeListener((DataChangeListener)owner);
        }
    }

    public ContainerListManager getOwner() {
        return this.m_Owner;
    }

    public synchronized void setColorProvider(AbstractColorProvider value) {
        this.m_ColorProvider = value;
        for (int i = 0; i < this.count(); ++i) {
            ((InstanceContainer)this.get(i)).setColor(this.getNextColor());
        }
    }

    public AbstractColorProvider getColorProvider() {
        return this.m_ColorProvider;
    }

    public Color getNextColor() {
        return this.m_ColorProvider.next();
    }

    public void clear() {
        this.m_FilteredList = null;
        super.clear();
        this.m_ColorProvider.resetColors();
    }

    public InstanceContainer newContainer(Comparable o) {
        return new InstanceContainer(this, (Instance)((Object)o));
    }

    public boolean isFiltered() {
        return this.m_FilteredList != null;
    }

    protected boolean updateSearchOnUpdate() {
        return true;
    }

    public void finishUpdate(boolean notify) {
        super.finishUpdate(notify);
        if (this.updateSearchOnUpdate() && notify) {
            this.updateSearch();
        }
    }

    public void add(InstanceContainer c) {
        c.setColor(this.getNextColor());
        super.add((AbstractContainer)c);
        if (!this.m_Updating && this.updateSearchOnUpdate()) {
            this.updateSearch();
        }
    }

    public InstanceContainer set(int index, InstanceContainer c) {
        InstanceContainer result = (InstanceContainer)super.set(index, (AbstractContainer)c);
        if (!this.m_Updating && this.updateSearchOnUpdate()) {
            this.updateSearch();
        }
        return result;
    }

    public InstanceContainer remove(int index) {
        if (!this.m_AllowRemoval) {
            return null;
        }
        InstanceContainer result = (InstanceContainer)super.remove(index);
        this.m_ColorProvider.recycle(result.getColor());
        if (!this.m_Updating && this.updateSearchOnUpdate()) {
            this.updateSearch();
        }
        return result;
    }

    public int indexOf(String id) {
        int result = -1;
        for (int i = 0; i < this.count(); ++i) {
            if (!((InstanceContainer)this.get(i)).getID().equals(id)) continue;
            result = i;
            break;
        }
        return result;
    }

    public int[] getVisibleIndices() {
        TIntArrayList result = new TIntArrayList();
        for (int i = 0; i < this.count(); ++i) {
            if (!this.isVisible(i)) continue;
            result.add(i);
        }
        return result.toArray();
    }

    public List<InstanceContainer> getAllVisible() {
        ArrayList<InstanceContainer> result = new ArrayList<InstanceContainer>();
        for (int i = 0; i < this.count(); ++i) {
            if (!this.isVisible(i)) continue;
            InstanceContainer cont = (InstanceContainer)((InstanceContainer)this.get(i)).copy();
            cont.setManager(null);
            result.add(cont);
        }
        return result;
    }

    public boolean isVisible(int index) {
        return ((InstanceContainer)this.get(index)).isVisible();
    }

    public void setVisible(int index, boolean visible) {
        ((InstanceContainer)this.get(index)).setVisible(visible);
        this.notifyDataChangeListeners(new DataChangeEvent((AbstractContainerManager)this, DataChangeEvent.Type.VISIBILITY, index));
    }

    public InstanceContainer getVisible(int index) {
        InstanceContainer result = null;
        int count = -1;
        for (int i = 0; i < this.count(); ++i) {
            if (this.isVisible(i)) {
                ++count;
            }
            if (count != index) continue;
            result = (InstanceContainer)this.get(i);
            break;
        }
        return result;
    }

    public int countVisible() {
        int result = 0;
        for (int i = 0; i < this.count(); ++i) {
            if (!this.isVisible(i)) continue;
            ++result;
        }
        return result;
    }

    public void search(String search, boolean regExp) {
        this.m_SearchString = search;
        this.m_SearchRegexp = regExp;
        this.updateSearch();
    }

    public void clearSearch() {
        this.search(null, false);
    }

    protected boolean isMatch(InstanceContainer cont, String search, boolean regExp) {
        if (regExp) {
            return cont.getID().matches(search);
        }
        return cont.getID().contains(search);
    }

    protected void updateSearch() {
        if (this.m_SearchString == null) {
            this.m_FilteredList = null;
            this.notifyDataChangeListeners(new DataChangeEvent((AbstractContainerManager)this, DataChangeEvent.Type.SEARCH));
            return;
        }
        TIntArrayList filtered = new TIntArrayList();
        for (int i = 0; i < this.m_List.size(); ++i) {
            if (!this.isMatch((InstanceContainer)((Object)this.m_List.get(i)), this.m_SearchString, this.m_SearchRegexp)) continue;
            filtered.add(i);
        }
        this.m_FilteredList = filtered;
        this.notifyDataChangeListeners(new DataChangeEvent((AbstractContainerManager)this, DataChangeEvent.Type.SEARCH));
    }

    public int[] getFilteredIndices() {
        if (this.m_FilteredList != null) {
            return this.m_FilteredList.toArray();
        }
        return new int[0];
    }

    public boolean isFiltered(int index) {
        return this.m_FilteredList != null && this.m_FilteredList.contains(index);
    }

    public InstanceContainer getFiltered(int index) {
        if (this.m_FilteredList == null) {
            return null;
        }
        return (InstanceContainer)((Object)this.m_List.get(this.m_FilteredList.get(index)));
    }

    public int indexOfFiltered(InstanceContainer c) {
        int result = -1;
        if (this.m_FilteredList != null) {
            for (int i = 0; i < this.m_FilteredList.size(); ++i) {
                if (!((InstanceContainer)((Object)this.m_List.get(this.m_FilteredList.get(i)))).equals((Object)c)) continue;
                result = i;
                break;
            }
        }
        return result;
    }

    public int countFiltered() {
        if (this.m_FilteredList == null) {
            return 0;
        }
        return this.m_FilteredList.size();
    }
}

