/*
 * Decompiled with CFR 0.152.
 */
package adams.multiprocess;

import adams.core.option.OptionUtils;
import adams.multiprocess.AbstractJob;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.core.Instances;

public class WekaCrossValidationJob
extends AbstractJob {
    private static final long serialVersionUID = -9085803857529039559L;
    protected Classifier m_Classifier;
    protected int m_Fold;
    protected Instances m_Train;
    protected Instances m_Test;
    protected boolean m_DiscardPredictions;
    protected Evaluation m_Evaluation;

    public WekaCrossValidationJob(Classifier classifier, Instances train, Instances test, int fold, boolean discardPred) {
        try {
            this.m_Classifier = (Classifier)OptionUtils.shallowCopy((Object)classifier);
        }
        catch (Exception e) {
            this.m_Classifier = null;
        }
        this.m_Train = train;
        this.m_Test = test;
        this.m_Fold = fold;
        this.m_DiscardPredictions = discardPred;
    }

    public Instances getTrain() {
        return this.m_Train;
    }

    public Instances getTest() {
        return this.m_Test;
    }

    public int getFold() {
        return this.m_Fold;
    }

    public boolean getDiscardPredictions() {
        return this.m_DiscardPredictions;
    }

    public Evaluation getEvaluation() {
        return this.m_Evaluation;
    }

    protected String preProcessCheck() {
        if (this.m_Classifier == null) {
            return "No classifier set/failed to copy!";
        }
        if (this.m_Train == null) {
            return "No training set!";
        }
        if (this.m_Test == null) {
            return "No test set!";
        }
        return null;
    }

    protected void process() throws Exception {
        this.m_Classifier.buildClassifier(this.m_Train);
        this.m_Evaluation = new Evaluation(this.m_Train);
        this.m_Evaluation.setDiscardPredictions(this.m_DiscardPredictions);
        this.m_Evaluation.evaluateModel(this.m_Classifier, this.m_Test, new Object[0]);
    }

    protected String postProcessCheck() {
        if (this.m_Evaluation == null) {
            return "Failed to evaluate?";
        }
        return null;
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_Train = null;
        this.m_Test = null;
        this.m_Evaluation = null;
    }

    public String toString() {
        return "classifier=" + OptionUtils.getCommandLine((Object)this.m_Classifier) + ", fold=" + this.m_Fold;
    }
}

